/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.browserwaiter.WaitConditionChecker;
import com.crawljax.core.CandidateCrawlAction;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CandidateElementExtractor;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.CrawlerLeftDomainException;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.StateUnreachableException;
import com.crawljax.core.UnfiredCandidateActions;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.core.state.CrawlPath;
import com.crawljax.core.state.Element;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateMachine;
import com.crawljax.core.state.StateVertex;
import com.crawljax.di.CoreModule;
import com.crawljax.forms.FormHandler;
import com.crawljax.forms.FormInput;
import com.crawljax.oraclecomparator.StateComparator;
import com.crawljax.util.ElementResolver;
import com.crawljax.util.UrlUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crawler {
    private static final Logger LOG = LoggerFactory.getLogger(Crawler.class);
    private final AtomicInteger crawlDepth = new AtomicInteger();
    private final int maxDepth;
    private final EmbeddedBrowser browser;
    private final CrawlerContext context;
    private final StateComparator stateComparator;
    private final URL url;
    private final Plugins plugins;
    private final FormHandler formHandler;
    private final CrawlRules crawlRules;
    private final WaitConditionChecker waitConditionChecker;
    private final CandidateElementExtractor candidateExtractor;
    private final UnfiredCandidateActions candidateActionCache;
    private final Provider<InMemoryStateFlowGraph> graphProvider;
    private CrawlPath crawlpath;
    private StateMachine stateMachine;

    @Inject
    Crawler(CrawlerContext context, CrawljaxConfiguration config, StateComparator stateComparator, UnfiredCandidateActions candidateActionCache, CoreModule.FormHandlerFactory formHandlerFactory, WaitConditionChecker waitConditionChecker, CoreModule.CandidateElementExtractorFactory elementExtractor, Provider<InMemoryStateFlowGraph> graphProvider, Plugins plugins) {
        this.context = context;
        this.graphProvider = graphProvider;
        this.browser = context.getBrowser();
        this.url = config.getUrl();
        this.plugins = plugins;
        this.crawlRules = config.getCrawlRules();
        this.maxDepth = config.getMaximumDepth();
        this.stateComparator = stateComparator;
        this.candidateActionCache = candidateActionCache;
        this.waitConditionChecker = waitConditionChecker;
        this.candidateExtractor = elementExtractor.newExtractor(this.browser);
        this.formHandler = formHandlerFactory.newFormHandler(this.browser);
    }

    public void close() {
        this.browser.close();
    }

    public void reset() {
        CrawlSession sess = this.context.getSession();
        if (this.crawlpath != null) {
            sess.addCrawlPath((List<Eventable>)((Object)this.crawlpath));
        }
        this.stateMachine = new StateMachine((InMemoryStateFlowGraph)this.graphProvider.get(), this.crawlRules.getInvariants(), this.plugins, this.stateComparator);
        this.context.setStateMachine(this.stateMachine);
        this.crawlpath = new CrawlPath();
        this.context.setCrawlPath(this.crawlpath);
        this.browser.goToUrl(this.url);
        this.plugins.runOnUrlLoadPlugins(this.context);
        this.crawlDepth.set(0);
    }

    public void execute(StateVertex crawlTask) {
        LOG.debug("Resetting the crawler and going to state {}", (Object)crawlTask.getName());
        this.reset();
        ImmutableList<Eventable> eventables = this.shortestPathTo(crawlTask);
        try {
            this.follow(CrawlPath.copyOf(eventables), crawlTask);
            this.crawlThroughActions();
        }
        catch (StateUnreachableException ex) {
            LOG.info(ex.getMessage());
            LOG.debug(ex.getMessage(), (Throwable)ex);
            this.candidateActionCache.purgeActionsForState(ex.getTarget());
        }
        catch (CrawlerLeftDomainException e) {
            LOG.info("The crawler left the domain. No biggy, whe'll just go somewhere else.");
            LOG.debug("Domain espace was {}", (Object)e.getMessage());
        }
    }

    private ImmutableList<Eventable> shortestPathTo(StateVertex crawlTask) {
        StateFlowGraph graph = this.context.getSession().getStateFlowGraph();
        return graph.getShortestPath(graph.getInitialState(), crawlTask);
    }

    private void follow(CrawlPath path, StateVertex targetState) throws StateUnreachableException, CrawljaxException {
        StateVertex curState = this.context.getSession().getInitialState();
        Iterator i$ = path.iterator();
        while (i$.hasNext()) {
            Eventable clickable = (Eventable)i$.next();
            this.checkCrawlConditions(targetState);
            LOG.debug("Backtracking by executing {} on element: {}", (Object)clickable.getEventType(), (Object)clickable);
            curState = this.changeState(targetState, clickable);
            this.handleInputElements(clickable);
            this.tryToFireEvent(targetState, curState, clickable);
            this.checkCrawlConditions(targetState);
        }
        if (!curState.equals(targetState)) {
            throw new StateUnreachableException(targetState, "The path didn't result in the desired state but in state " + curState.getName());
        }
    }

    private void checkCrawlConditions(StateVertex targetState) {
        if (!this.candidateExtractor.checkCrawlCondition()) {
            throw new StateUnreachableException(targetState, "Crawl conditions not complete. Not following path");
        }
    }

    private StateVertex changeState(StateVertex targetState, Eventable clickable) {
        boolean switched = this.stateMachine.changeState(clickable.getTargetStateVertex());
        if (!switched) {
            throw new StateUnreachableException(targetState, "Could not switch states");
        }
        StateVertex curState = clickable.getTargetStateVertex();
        this.crawlpath.add(clickable);
        return curState;
    }

    private void tryToFireEvent(StateVertex targetState, StateVertex curState, Eventable clickable) {
        if (this.fireEvent(clickable)) {
            if (this.crawlerLeftDomain()) {
                throw new StateUnreachableException(targetState, "Domain left while following path");
            }
        } else {
            throw new StateUnreachableException(targetState, "couldn't fire eventable " + clickable);
        }
        int depth = this.crawlDepth.incrementAndGet();
        LOG.info("Crawl depth is now {}", (Object)depth);
        this.plugins.runOnRevisitStatePlugins(this.context, curState);
    }

    private void handleInputElements(Eventable eventable) {
        CopyOnWriteArrayList<FormInput> formInputs = eventable.getRelatedFormInputs();
        for (FormInput formInput : this.formHandler.getFormInputs()) {
            if (formInputs.contains(formInput)) continue;
            formInputs.add(formInput);
        }
        this.formHandler.handleFormElements(formInputs);
    }

    private boolean fireEvent(Eventable eventable) {
        Eventable eventToFire = eventable;
        if (eventable.getIdentification().getHow().toString().equals("xpath") && eventable.getRelatedFrame().equals("")) {
            eventToFire = this.resolveByXpath(eventable, eventToFire);
        }
        boolean isFired = false;
        try {
            isFired = this.browser.fireEventAndWait(eventToFire);
        }
        catch (ElementNotVisibleException | NoSuchElementException e) {
            if (this.crawlRules.isCrawlHiddenAnchors() && eventToFire.getElement() != null && "A".equals(eventToFire.getElement().getTag())) {
                isFired = this.visitAnchorHrefIfPossible(eventToFire);
            } else {
                LOG.debug("Ignoring invisble element {}", (Object)eventToFire.getElement());
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted during fire event");
            Thread.currentThread().interrupt();
            return false;
        }
        LOG.debug("Event fired={} for eventable {}", (Object)isFired, (Object)eventable);
        if (isFired) {
            this.waitConditionChecker.wait(this.browser);
            this.browser.closeOtherWindows();
            return true;
        }
        this.plugins.runOnFireEventFailedPlugins(this.context, eventable, (List<Eventable>)((Object)this.crawlpath.immutableCopyWithoutLast()));
        return false;
    }

    private Eventable resolveByXpath(Eventable eventable, Eventable eventToFire) {
        String xpath = eventable.getIdentification().getValue();
        Eventable.EventType eventType = eventable.getEventType();
        String newXPath = new ElementResolver(eventable, this.browser).resolve();
        if (newXPath != null && !xpath.equals(newXPath)) {
            LOG.debug("XPath changed from {} to {} relatedFrame: {}", new Object[]{xpath, newXPath, eventable.getRelatedFrame()});
            eventToFire = new Eventable(new Identification(Identification.How.xpath, newXPath), eventType);
        }
        return eventToFire;
    }

    private boolean visitAnchorHrefIfPossible(Eventable eventable) {
        Element element = eventable.getElement();
        String href = element.getAttributeOrNull("href");
        if (href == null) {
            LOG.info("Anchor {} has no href and is invisble so it will be ignored", (Object)element);
        } else {
            LOG.info("Found an invisible link with href={}", (Object)href);
            try {
                URL url = UrlUtils.extractNewUrl(this.browser.getCurrentUrl(), href);
                this.browser.goToUrl(url);
                return true;
            }
            catch (MalformedURLException e) {
                LOG.info("Could not visit invisible illegal URL {}", (Object)e.getMessage());
            }
        }
        return false;
    }

    private void crawlThroughActions() {
        boolean interrupted = Thread.interrupted();
        CandidateCrawlAction action = this.candidateActionCache.pollActionOrNull(this.stateMachine.getCurrentState());
        while (action != null && !interrupted) {
            CandidateElement element = action.getCandidateElement();
            if (element.allConditionsSatisfied(this.browser)) {
                Eventable event = new Eventable(element, action.getEventType());
                this.handleInputElements(event);
                this.waitForRefreshTagIfAny(event);
                boolean fired = this.fireEvent(event);
                if (fired) {
                    this.inspectNewState(event);
                }
            } else {
                LOG.info("Element {} not clicked because not all crawl conditions where satisfied", (Object)element);
            }
            action = this.candidateActionCache.pollActionOrNull(this.stateMachine.getCurrentState());
            interrupted = Thread.interrupted();
            if (interrupted || !this.crawlerLeftDomain()) continue;
            throw new CrawlerLeftDomainException(this.browser.getCurrentUrl());
        }
        if (interrupted) {
            LOG.info("Interrupted while firing actions. Putting back the actions on the todo list");
            if (action != null) {
                this.candidateActionCache.addActions((Collection<CandidateCrawlAction>)ImmutableList.of((Object)action), this.stateMachine.getCurrentState());
            }
            Thread.currentThread().interrupt();
        }
    }

    private void inspectNewState(Eventable event) {
        if (this.crawlerLeftDomain()) {
            LOG.debug("The browser left the domain. Going back one state...");
            this.goBackOneState();
        } else {
            StateVertex newState = this.stateMachine.newStateFor(this.browser);
            if (this.domChanged(event, newState)) {
                this.inspectNewDom(event, newState);
            } else {
                LOG.debug("Dom unchanged");
            }
        }
    }

    private boolean domChanged(Eventable eventable, StateVertex newState) {
        return this.plugins.runDomChangeNotifierPlugins(this.context, this.stateMachine.getCurrentState(), eventable, newState);
    }

    private void inspectNewDom(Eventable event, StateVertex newState) {
        LOG.debug("The DOM has changed. Event added to the crawl path");
        this.crawlpath.add(event);
        boolean isNewState = this.stateMachine.swithToStateAndCheckIfClone(event, newState, this.context);
        if (isNewState) {
            int depth = this.crawlDepth.incrementAndGet();
            LOG.info("New DOM is a new state! crawl depth is now {}", (Object)depth);
            if (this.maxDepth == depth) {
                LOG.debug("Maximum depth achived. Not crawling this state any further");
            } else {
                this.parseCurrentPageForCandidateElements();
            }
        } else {
            LOG.debug("New DOM is a clone state. Continuing in that state.");
            this.context.getSession().addCrawlPath((List<Eventable>)((Object)this.crawlpath.immutableCopy()));
        }
    }

    private void parseCurrentPageForCandidateElements() {
        StateVertex currentState = this.stateMachine.getCurrentState();
        LOG.debug("Parsing DOM of state {} for candidate elements", (Object)currentState.getName());
        ImmutableList<CandidateElement> extract = this.candidateExtractor.extract(currentState);
        this.plugins.runPreStateCrawlingPlugins(this.context, extract, currentState);
        this.candidateActionCache.addActions(extract, currentState);
    }

    private void waitForRefreshTagIfAny(Eventable eventable) {
        if ("meta".equalsIgnoreCase(eventable.getElement().getTag())) {
            Pattern p = Pattern.compile("(\\d+);\\s+URL=(.*)");
            for (Map.Entry e : eventable.getElement().getAttributes().entrySet()) {
                Matcher m = p.matcher((CharSequence)e.getValue());
                long waitTime = this.parseWaitTimeOrReturnDefault(m);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException ex) {
                    LOG.info("Crawler timed out while waiting for page to reload");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private boolean crawlerLeftDomain() {
        return !UrlUtils.isSameDomain(this.browser.getCurrentUrl(), this.url);
    }

    private long parseWaitTimeOrReturnDefault(Matcher m) {
        long waitTime = TimeUnit.SECONDS.toMillis(10L);
        if (m.find()) {
            LOG.debug("URL: {}", (Object)m.group(2));
            try {
                waitTime = Integer.parseInt(m.group(1)) * 1000;
            }
            catch (NumberFormatException ex) {
                LOG.info("Could parse the amount of time to wait for a META tag refresh. Waiting 10 seconds...");
            }
        }
        return waitTime;
    }

    private void goBackOneState() {
        LOG.debug("Going back one state");
        CrawlPath currentPath = this.crawlpath.immutableCopy();
        this.crawlpath = null;
        StateVertex current = this.stateMachine.getCurrentState();
        this.reset();
        this.follow(currentPath, current);
    }

    public StateVertex crawlIndex() {
        LOG.debug("Setting up vertex of the index page");
        this.browser.goToUrl(this.url);
        this.plugins.runOnUrlLoadPlugins(this.context);
        StateVertex index = StateMachine.createIndex(this.url.toExternalForm(), this.browser.getStrippedDom(), this.stateComparator.getStrippedDom(this.browser));
        Preconditions.checkArgument((index.getId() == 0 ? 1 : 0) != 0, (Object)"It seems some the index state is crawled more than once.");
        LOG.debug("Parsing the index for candidate elements");
        ImmutableList<CandidateElement> extract = this.candidateExtractor.extract(index);
        this.plugins.runPreStateCrawlingPlugins(this.context, extract, index);
        this.candidateActionCache.addActions(extract, index);
        return index;
    }

    public CrawlerContext getContext() {
        return this.context;
    }
}

