/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.codahale.metrics.MetricRegistry;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.CrawlPath;
import com.crawljax.core.state.StateMachine;
import com.crawljax.core.state.StateVertex;
import javax.inject.Inject;
import javax.inject.Provider;

public class CrawlerContext {
    private final EmbeddedBrowser browser;
    private final Provider<CrawlSession> sessionProvider;
    private final CrawljaxConfiguration config;
    private final ExitNotifier exitNotifier;
    private final MetricRegistry registry;
    private StateMachine stateMachine;
    private CrawlPath crawlpath;

    @Inject
    public CrawlerContext(EmbeddedBrowser browser, CrawljaxConfiguration config, Provider<CrawlSession> sessionProvider, ExitNotifier exitNotifier, MetricRegistry registry) {
        this.browser = browser;
        this.config = config;
        this.sessionProvider = sessionProvider;
        this.exitNotifier = exitNotifier;
        this.registry = registry;
    }

    public EmbeddedBrowser getBrowser() {
        return this.browser;
    }

    public CrawlSession getSession() {
        return (CrawlSession)this.sessionProvider.get();
    }

    public CrawljaxConfiguration getConfig() {
        return this.config;
    }

    void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public void stop() {
        this.exitNotifier.stop();
    }

    public StateVertex getCurrentState() {
        if (this.stateMachine == null) {
            return null;
        }
        return this.stateMachine.getCurrentState();
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    protected void setCrawlPath(CrawlPath path) {
        this.crawlpath = path;
    }

    public CrawlPath getCrawlPath() {
        return this.crawlpath.immutableCopy();
    }
}

