/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.core.CrawlController;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.di.CoreModule;
import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.concurrent.Callable;

public class CrawljaxRunner
implements Callable<CrawlSession> {
    private final CrawljaxConfiguration config;
    private CrawlController controller;
    private ExitNotifier.ExitStatus reason;

    public CrawljaxRunner(CrawljaxConfiguration config) {
        this.config = config;
    }

    @Override
    public CrawlSession call() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new CoreModule(this.config)});
        this.controller = (CrawlController)injector.getInstance(CrawlController.class);
        CrawlSession session = this.controller.call();
        this.reason = this.controller.getReason();
        return session;
    }

    public void stop() {
        Preconditions.checkNotNull((Object)this.controller, (Object)"Cannot stop Crawljax if you haven't started it");
        this.controller.stop();
    }

    public ExitNotifier.ExitStatus getReason() {
        return this.reason;
    }
}

