/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Singleton;

@Singleton
@ThreadSafe
public class ExitNotifier {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicInteger states = new AtomicInteger();
    private final int maxStates;
    private ExitStatus reason = ExitStatus.ERROR;

    public ExitNotifier(int maxStates) {
        this.maxStates = maxStates;
    }

    public ExitStatus awaitTermination() throws InterruptedException {
        this.latch.await();
        return this.reason;
    }

    public int incrementNumberOfStates() {
        int count = this.states.incrementAndGet();
        if (count == this.maxStates) {
            this.reason = ExitStatus.MAX_STATES;
            this.latch.countDown();
        }
        return count;
    }

    public void signalTimeIsUp() {
        this.reason = ExitStatus.MAX_TIME;
        this.latch.countDown();
    }

    public void signalCrawlExhausted() {
        this.reason = ExitStatus.EXHAUSTED;
        this.latch.countDown();
    }

    public void stop() {
        this.reason = ExitStatus.STOPPED;
        this.latch.countDown();
    }

    @VisibleForTesting
    boolean isExitCalled() {
        return this.latch.getCount() == 0L;
    }

    public static enum ExitStatus {
        MAX_STATES("Maximum states passed"),
        MAX_TIME("Maximum time passed"),
        EXHAUSTED("Exausted"),
        ERROR("Errored"),
        STOPPED("Stopped manually");

        private final String readableName;

        private ExitStatus(String readableName) {
            this.readableName = readableName;
        }

        public String toString() {
            return this.readableName;
        }
    }
}

