/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.crawljax.core.CandidateCrawlAction;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UnfiredCandidateActions {
    private static final Logger LOG = LoggerFactory.getLogger(UnfiredCandidateActions.class);
    private final Map<Integer, Queue<CandidateCrawlAction>> cache;
    private final BlockingQueue<Integer> statesWithCandidates;
    private final Striped<Lock> locks;
    private final Provider<StateFlowGraph> sfg;
    private final Counter crawlerLostCount;
    private final Counter unfiredActionsCount;

    @Inject
    UnfiredCandidateActions(BrowserConfiguration config, Provider<StateFlowGraph> sfg, MetricRegistry registry) {
        this.sfg = sfg;
        this.cache = Maps.newHashMap();
        this.statesWithCandidates = Queues.newLinkedBlockingQueue();
        this.locks = Striped.lock((int)config.getNumberOfBrowsers());
        this.crawlerLostCount = (Counter)registry.register("com.crawljax.crawlevents.crawler_lost", (Metric)new Counter());
        this.unfiredActionsCount = (Counter)registry.register("com.crawljax.crawlevents.unfired_actions", (Metric)new Counter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CandidateCrawlAction pollActionOrNull(StateVertex state) {
        LOG.debug("Polling action for state {}", (Object)state.getName());
        Lock lock = (Lock)this.locks.get((Object)state.getId());
        try {
            lock.lock();
            Queue<CandidateCrawlAction> queue = this.cache.get(state.getId());
            if (queue == null) {
                CandidateCrawlAction candidateCrawlAction = null;
                return candidateCrawlAction;
            }
            CandidateCrawlAction action = queue.poll();
            if (queue.isEmpty()) {
                LOG.debug("All actions polled for state {}", (Object)state.getName());
                this.cache.remove(state.getId());
                this.removeStateFromQueue(state.getId());
                LOG.debug("There are now {} states with unfinished actions", (Object)this.cache.size());
            }
            CandidateCrawlAction candidateCrawlAction = action;
            return candidateCrawlAction;
        }
        finally {
            lock.unlock();
        }
    }

    private void removeStateFromQueue(int id) {
        while (this.statesWithCandidates.remove(id)) {
            LOG.trace("Removed id {} from the queue", (Object)id);
        }
    }

    public void addActions(ImmutableList<CandidateElement> extract, StateVertex currentState) {
        ArrayList<CandidateCrawlAction> actions = new ArrayList<CandidateCrawlAction>(extract.size());
        for (CandidateElement candidateElement : extract) {
            actions.add(new CandidateCrawlAction(candidateElement, Eventable.EventType.click));
        }
        this.addActions(actions, currentState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActions(Collection<CandidateCrawlAction> actions, StateVertex state) {
        if (actions.isEmpty()) {
            LOG.debug("Received empty actions list. Ignoring...");
            return;
        }
        Lock lock = (Lock)this.locks.get((Object)state.getId());
        try {
            lock.lock();
            LOG.debug("Adding {} crawl actions for state {}", (Object)actions.size(), (Object)state.getId());
            if (this.cache.containsKey(state.getId())) {
                this.cache.get(state.getId()).addAll(actions);
            } else {
                this.cache.put(state.getId(), Queues.newConcurrentLinkedQueue(actions));
            }
            this.statesWithCandidates.add(state.getId());
            LOG.info("There are {} states with unfired actions", (Object)this.statesWithCandidates.size());
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.statesWithCandidates.isEmpty();
    }

    public StateVertex awaitNewTask() throws InterruptedException {
        int id = this.statesWithCandidates.take();
        this.statesWithCandidates.add(id);
        LOG.debug("New task polled for state {}", (Object)id);
        LOG.info("There are {} states with unfired actions", (Object)this.statesWithCandidates.size());
        return ((StateFlowGraph)this.sfg.get()).getById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeActionsForState(StateVertex crawlTask) {
        Lock lock = (Lock)this.locks.get((Object)crawlTask.getId());
        try {
            lock.lock();
            LOG.debug("Removing tasks for target state {}", (Object)crawlTask.getName());
            this.removeStateFromQueue(crawlTask.getId());
            Queue<CandidateCrawlAction> removed = this.cache.remove(crawlTask.getId());
            if (removed != null) {
                this.unfiredActionsCount.inc((long)removed.size());
            }
        }
        finally {
            lock.unlock();
            this.crawlerLostCount.inc();
        }
    }
}

