/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.browser.EmbeddedBrowser;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;
import javax.inject.Provider;

@Immutable
public class BrowserConfiguration {
    public static final int BROWSER_START_RETRIES = 2;
    public static final long BROWSER_SLEEP_FAILURE = TimeUnit.SECONDS.toMillis(10L);
    private static final Provider<EmbeddedBrowser> DEFAULT_BROWSER_BUILDER = new Provider<EmbeddedBrowser>(){

        public EmbeddedBrowser get() {
            throw new IllegalStateException("This is just a placeholder and should not be called");
        }

        public String toString() {
            return "Default webdriver factory";
        }
    };
    private final EmbeddedBrowser.BrowserType browsertype;
    private final int numberOfBrowsers;
    private final Provider<EmbeddedBrowser> browserBuilder;
    private String remoteHubUrl;
    private String lang;

    public static BrowserConfiguration remoteConfig(int numberOfBrowsers, String remoteUrl) {
        BrowserConfiguration config = new BrowserConfiguration(EmbeddedBrowser.BrowserType.REMOTE, numberOfBrowsers);
        config.remoteHubUrl = remoteUrl;
        return config;
    }

    public BrowserConfiguration(EmbeddedBrowser.BrowserType browsertype) {
        this(browsertype, 1);
    }

    public BrowserConfiguration(EmbeddedBrowser.BrowserType browsertype, int numberOfBrowsers) {
        this(browsertype, numberOfBrowsers, DEFAULT_BROWSER_BUILDER);
    }

    public BrowserConfiguration(EmbeddedBrowser.BrowserType browsertype, int numberOfBrowsers, Provider<EmbeddedBrowser> builder) {
        Preconditions.checkArgument((numberOfBrowsers > 0 ? 1 : 0) != 0, (Object)"Number of browsers should be 1 or more");
        Preconditions.checkNotNull((Object)((Object)browsertype));
        Preconditions.checkNotNull(builder);
        this.browsertype = browsertype;
        this.numberOfBrowsers = numberOfBrowsers;
        this.browserBuilder = builder;
    }

    public EmbeddedBrowser.BrowserType getBrowsertype() {
        return this.browsertype;
    }

    public int getNumberOfBrowsers() {
        return this.numberOfBrowsers;
    }

    public Provider<EmbeddedBrowser> getBrowserBuilder() {
        return this.browserBuilder;
    }

    public String getRemoteHubUrl() {
        return this.remoteHubUrl;
    }

    public boolean isDefaultBuilder() {
        return this.browserBuilder.equals(DEFAULT_BROWSER_BUILDER);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("browsertype", (Object)this.browsertype).add("numberOfBrowsers", this.numberOfBrowsers).add("browserBuilder", this.browserBuilder).add("remoteHubUrl", (Object)this.remoteHubUrl).add("language", (Object)this.lang).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.browsertype, this.numberOfBrowsers, this.browserBuilder, this.remoteHubUrl, this.lang});
    }

    public boolean equals(Object object) {
        if (object instanceof BrowserConfiguration) {
            BrowserConfiguration that = (BrowserConfiguration)object;
            return Objects.equal((Object)((Object)this.browsertype), (Object)((Object)that.browsertype)) && Objects.equal((Object)this.numberOfBrowsers, (Object)that.numberOfBrowsers) && Objects.equal(this.browserBuilder, that.browserBuilder) && Objects.equal((Object)this.remoteHubUrl, (Object)that.remoteHubUrl) && Objects.equal((Object)this.lang, (Object)that.lang);
        }
        return false;
    }

    public String getLangOrNull() {
        return this.lang;
    }

    public void setLang(String lang) {
        Preconditions.checkNotNull((Object)lang, (Object)"The language cannot be null");
        this.lang = lang;
    }
}

