/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.core.configuration.CrawlElement;
import com.crawljax.core.state.Eventable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlActionsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CrawlActionsBuilder.class);
    private final List<CrawlElement> crawlElements = Lists.newLinkedList();
    private final List<CrawlElement> crawlElementsExcluded = Lists.newLinkedList();
    private final List<ExcludeByParentBuilder> crawlParentsExcluded = Lists.newLinkedList();
    private ImmutableList<CrawlElement> resultingElementsExcluded = null;

    CrawlActionsBuilder() {
    }

    public CrawlElement click(String tagName) {
        this.checkNotRead();
        Preconditions.checkNotNull((Object)tagName, (Object)"Tagname cannot be null");
        CrawlElement crawlTag = new CrawlElement(Eventable.EventType.click, tagName.toUpperCase());
        this.crawlElements.add(crawlTag);
        return crawlTag;
    }

    public void click(String ... tagNames) {
        for (String tagName : tagNames) {
            this.click(tagName);
        }
    }

    public void clickDefaultElements() {
        this.click("a");
        this.click("button");
        this.click("input").withAttribute("type", "submit");
        this.click("input").withAttribute("type", "button");
    }

    private void checkNotRead() {
        Preconditions.checkState((this.resultingElementsExcluded == null ? 1 : 0) != 0, (Object)"You cannot modify crawlactions once it's read");
    }

    public CrawlElement dontClick(String tagName) {
        this.checkNotRead();
        Preconditions.checkNotNull((Object)tagName, (Object)"Tagname cannot be null");
        CrawlElement crawlTag = new CrawlElement(Eventable.EventType.click, tagName.toUpperCase());
        this.crawlElementsExcluded.add(crawlTag);
        return crawlTag;
    }

    public ExcludeByParentBuilder dontClickChildrenOf(String tagname) {
        this.checkNotRead();
        Preconditions.checkNotNull((Object)tagname);
        ExcludeByParentBuilder exclude = new ExcludeByParentBuilder(tagname.toUpperCase());
        this.crawlParentsExcluded.add(exclude);
        return exclude;
    }

    private ImmutableList<CrawlElement> getCrawlElements() {
        if (this.crawlElements.isEmpty()) {
            this.clickDefaultElements();
        }
        return ImmutableList.copyOf(this.crawlElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableList<CrawlElement> getCrawlElementsExcluded() {
        CrawlActionsBuilder crawlActionsBuilder = this;
        synchronized (crawlActionsBuilder) {
            if (this.resultingElementsExcluded == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll(this.crawlElementsExcluded);
                for (ExcludeByParentBuilder exclude : this.crawlParentsExcluded) {
                    builder.addAll((Iterable)exclude.asExcludeList(this.crawlElements));
                }
                this.resultingElementsExcluded = builder.build();
                LOG.debug("Excluded elements = {}", this.resultingElementsExcluded);
            }
            return this.resultingElementsExcluded;
        }
    }

    Pair<ImmutableList<CrawlElement>, ImmutableList<CrawlElement>> build() {
        return Pair.of(this.getCrawlElements(), this.getCrawlElementsExcluded());
    }

    public static class ExcludeByParentBuilder {
        private final String tagname;
        private String id = null;
        private String clasz = null;

        private ExcludeByParentBuilder(String tagname) {
            this.tagname = tagname;
        }

        public void withId(String id) {
            this.id = id;
        }

        public void withClass(String clasz) {
            this.clasz = clasz;
        }

        private String asExcludeXpath(String identifier, String value) {
            return "//" + this.tagname.toUpperCase() + "[@" + identifier + "='" + value + "']//*";
        }

        private ImmutableList<CrawlElement> asExcludeList(List<CrawlElement> includes) {
            String xpath = this.id != null ? this.asExcludeXpath("id", this.id) : (this.clasz != null ? this.asExcludeXpath("class", this.clasz) : "//" + this.tagname.toUpperCase() + "//*");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (CrawlElement include : includes) {
                builder.add((Object)new CrawlElement(Eventable.EventType.click, include.getTagName()).underXPath(xpath));
            }
            return builder.build();
        }
    }
}

