/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.condition.Condition;
import com.crawljax.condition.eventablecondition.EventableCondition;
import com.crawljax.core.state.Eventable;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public final class CrawlElement {
    private final String tagName;
    private final List<Condition> conditions = Lists.newLinkedList();
    private final String id;
    private final Eventable.EventType eventType;
    private final List<String> inputFieldIds = Lists.newLinkedList();
    private String underXpath;

    protected CrawlElement(Eventable.EventType eventType, String tagName) {
        this.tagName = tagName.toUpperCase();
        this.id = "id" + this.hashCode();
        this.eventType = eventType;
    }

    public CrawlElement when(Condition ... conditions) {
        this.conditions.addAll(Arrays.asList(conditions));
        return this;
    }

    public CrawlElement withAttribute(String attributeName, String value) {
        this.underXpath = this.underXpath == null || this.underXpath.isEmpty() ? "//" + this.tagName + "[@" + attributeName + "='" + value + "']" : this.underXpath + " | " + "//" + this.tagName + "[@" + attributeName + "='" + value + "']";
        return this;
    }

    public CrawlElement underXPath(String xpathExpression) {
        this.underXpath = xpathExpression;
        return this;
    }

    public CrawlElement withText(String text) {
        this.underXpath = this.underXpath == null || this.underXpath.isEmpty() ? "//" + this.tagName + "[text()=" + this.escapeApostrophes(text) + "]" : this.underXpath + " | " + "//" + this.tagName + "[text()=" + this.escapeApostrophes(text) + "]";
        return this;
    }

    public EventableCondition getEventableCondition() {
        if ((this.getWithXpathExpression() == null || this.getWithXpathExpression().equals("")) && this.getConditions().isEmpty() && this.getInputFieldIds().isEmpty()) {
            return null;
        }
        EventableCondition eventableCondition = new EventableCondition(this.getId());
        if (this.getWithXpathExpression() != null && !this.getWithXpathExpression().equals("")) {
            eventableCondition.setInXPath(this.getWithXpathExpression());
        }
        if (this.getConditions().size() > 0) {
            eventableCondition.setConditions((List<Condition>)this.getConditions());
        }
        if (this.getInputFieldIds().size() > 0) {
            eventableCondition.setLinkedInputFields((List<String>)this.getInputFieldIds());
        }
        return eventableCondition;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tagName", (Object)this.tagName).add("conditions", this.conditions).add("id", (Object)this.id).add("eventType", (Object)this.eventType).add("inputFieldIds", this.inputFieldIds).add("underXpath", (Object)this.underXpath).toString();
    }

    public String getId() {
        return this.id;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getWithXpathExpression() {
        return this.underXpath;
    }

    protected void setConditions(Condition ... conditions) {
        for (Condition condition : conditions) {
            this.conditions.add(condition);
        }
    }

    protected ImmutableList<Condition> getConditions() {
        return ImmutableList.copyOf(this.conditions);
    }

    protected ImmutableList<String> getInputFieldIds() {
        return ImmutableList.copyOf(this.inputFieldIds);
    }

    protected void addInputFieldIds(List<String> ids) {
        this.inputFieldIds.addAll(ids);
    }

    public Eventable.EventType getEventType() {
        return this.eventType;
    }

    protected String escapeApostrophes(String text) {
        String resultString;
        if (text.contains("'")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("concat('");
            stringBuilder.append(text.replace("'", "',\"'\",'"));
            stringBuilder.append("')");
            resultString = stringBuilder.toString();
        } else {
            resultString = "'" + text + "'";
        }
        return resultString;
    }
}

