/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.condition.Condition;
import com.crawljax.condition.browserwaiter.WaitCondition;
import com.crawljax.condition.crawlcondition.CrawlCondition;
import com.crawljax.condition.invariant.Invariant;
import com.crawljax.core.configuration.CrawlActionsBuilder;
import com.crawljax.core.configuration.CrawlElement;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.configuration.InputSpecification;
import com.crawljax.core.configuration.PreCrawlConfiguration;
import com.crawljax.core.state.Eventable;
import com.crawljax.oraclecomparator.OracleComparator;
import com.crawljax.oraclecomparator.comparators.SimpleComparator;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.concurrent.TimeUnit;

public class CrawlRules {
    public static final long DEFAULT_WAIT_AFTER_RELOAD = 500L;
    public static final long DEFAULT_WAIT_AFTER_EVENT = 500L;
    private ImmutableSortedSet<Eventable.EventType> crawlEvents;
    private ImmutableList<Invariant> invariants;
    private ImmutableList<OracleComparator> oracleComparators;
    private ImmutableSortedSet<String> ignoredFrameIdentifiers;
    private PreCrawlConfiguration preCrawlConfig;
    private boolean randomInputInForms = true;
    private InputSpecification inputSpecification = new InputSpecification();
    private boolean testInvariantsWhileCrawling = true;
    private boolean clickOnce = true;
    private boolean randomizeCandidateElements = false;
    private boolean crawlFrames = true;
    private boolean crawlHiddenAnchors = false;
    private long waitAfterReloadUrl = 500L;
    private long waitAfterEvent = 500L;
    private boolean followExternalLinks = false;

    public static CrawlRulesBuilder builder(CrawljaxConfiguration.CrawljaxConfigurationBuilder builder) {
        return new CrawlRulesBuilder(builder);
    }

    private CrawlRules() {
    }

    public ImmutableSortedSet<Eventable.EventType> getCrawlEvents() {
        return this.crawlEvents;
    }

    public ImmutableList<Invariant> getInvariants() {
        return this.invariants;
    }

    public ImmutableList<OracleComparator> getOracleComparators() {
        return this.oracleComparators;
    }

    public PreCrawlConfiguration getPreCrawlConfig() {
        return this.preCrawlConfig;
    }

    public boolean isRandomInputInForms() {
        return this.randomInputInForms;
    }

    public InputSpecification getInputSpecification() {
        return this.inputSpecification;
    }

    public boolean isTestInvariantsWhileCrawling() {
        return this.testInvariantsWhileCrawling;
    }

    public boolean isClickOnce() {
        return this.clickOnce;
    }

    public boolean isRandomizeCandidateElements() {
        return this.randomizeCandidateElements;
    }

    public boolean shouldCrawlFrames() {
        return this.crawlFrames;
    }

    public boolean isCrawlHiddenAnchors() {
        return this.crawlHiddenAnchors;
    }

    public long getWaitAfterReloadUrl() {
        return this.waitAfterReloadUrl;
    }

    public long getWaitAfterEvent() {
        return this.waitAfterEvent;
    }

    public ImmutableSortedSet<String> getIgnoredFrameIdentifiers() {
        return this.ignoredFrameIdentifiers;
    }

    public ImmutableList<CrawlElement> getAllCrawlElements() {
        return new ImmutableList.Builder().addAll(this.getPreCrawlConfig().getIncludedElements()).addAll(this.getPreCrawlConfig().getExcludedElements()).addAll(this.getInputSpecification().getCrawlElements()).build();
    }

    public boolean followExternalLinks() {
        return this.followExternalLinks;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.crawlEvents, this.invariants, this.oracleComparators, this.ignoredFrameIdentifiers, this.preCrawlConfig, this.randomInputInForms, this.inputSpecification, this.testInvariantsWhileCrawling, this.clickOnce, this.crawlFrames, this.crawlHiddenAnchors, this.waitAfterReloadUrl, this.waitAfterEvent, this.followExternalLinks});
    }

    public boolean equals(Object object) {
        if (object instanceof CrawlRules) {
            CrawlRules that = (CrawlRules)object;
            return Objects.equal(this.crawlEvents, that.crawlEvents) && Objects.equal(this.invariants, that.invariants) && Objects.equal(this.oracleComparators, that.oracleComparators) && Objects.equal(this.ignoredFrameIdentifiers, that.ignoredFrameIdentifiers) && Objects.equal((Object)this.preCrawlConfig, (Object)that.preCrawlConfig) && Objects.equal((Object)this.randomInputInForms, (Object)that.randomInputInForms) && Objects.equal((Object)this.inputSpecification, (Object)that.inputSpecification) && Objects.equal((Object)this.testInvariantsWhileCrawling, (Object)that.testInvariantsWhileCrawling) && Objects.equal((Object)this.clickOnce, (Object)that.clickOnce) && Objects.equal((Object)this.randomizeCandidateElements, (Object)that.randomizeCandidateElements) && Objects.equal((Object)this.crawlFrames, (Object)that.crawlFrames) && Objects.equal((Object)this.crawlHiddenAnchors, (Object)that.crawlHiddenAnchors) && Objects.equal((Object)this.waitAfterReloadUrl, (Object)that.waitAfterReloadUrl) && Objects.equal((Object)this.waitAfterEvent, (Object)that.waitAfterEvent) && Objects.equal((Object)this.followExternalLinks, (Object)that.followExternalLinks);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("DEFAULT_WAIT_AFTER_RELOAD", 500L).add("DEFAULT_WAIT_AFTER_EVENT", 500L).add("crawlEvents", this.crawlEvents).add("invariants", this.invariants).add("oracleComparators", this.oracleComparators).add("ignoredFrameIdentifiers", this.ignoredFrameIdentifiers).add("preCrawlConfig", (Object)this.preCrawlConfig).add("randomInputInForms", this.randomInputInForms).add("inputSpecification", (Object)this.inputSpecification).add("testInvariantsWhileCrawling", this.testInvariantsWhileCrawling).add("clickOnce", this.clickOnce).add("randomizeCandidateElements", this.randomizeCandidateElements).add("crawlFrames", this.crawlFrames).add("crawlHiddenAnchors", this.crawlHiddenAnchors).add("waitAfterReloadUrl", this.waitAfterReloadUrl).add("waitAfterEvent", this.waitAfterEvent).add("followExternalLinks", this.followExternalLinks).toString();
    }

    public static final class CrawlRulesBuilder {
        private final CrawlRules crawlRules;
        private ImmutableSortedSet.Builder<Eventable.EventType> crawlEvents = ImmutableSortedSet.naturalOrder();
        private ImmutableList.Builder<Invariant> invariants = ImmutableList.builder();
        private ImmutableList.Builder<OracleComparator> oracleComparators = ImmutableList.builder();
        private final CrawlActionsBuilder crawlActionsBuilder;
        private final PreCrawlConfiguration.PreCrawlConfigurationBuilder preCrawlConfig;
        private final ImmutableSortedSet.Builder<String> ignoredFrameIdentifiers = ImmutableSortedSet.naturalOrder();
        private final CrawljaxConfiguration.CrawljaxConfigurationBuilder crawljaxBuilder;

        private CrawlRulesBuilder(CrawljaxConfiguration.CrawljaxConfigurationBuilder crawljaxBuilder) {
            this.crawljaxBuilder = crawljaxBuilder;
            this.crawlRules = new CrawlRules();
            this.crawlActionsBuilder = new CrawlActionsBuilder();
            this.preCrawlConfig = PreCrawlConfiguration.builder();
        }

        public CrawlRulesBuilder insertRandomDataInInputForms(boolean insertRandomData) {
            this.crawlRules.randomInputInForms = insertRandomData;
            return this;
        }

        public CrawlRulesBuilder dontCrawlFrame(String frame) {
            Preconditions.checkNotNull((Object)frame);
            this.ignoredFrameIdentifiers.add((Object)frame);
            return this;
        }

        public CrawlRulesBuilder addEventType(Eventable.EventType ... eventTypes) {
            this.crawlEvents.add((Object[])eventTypes);
            return this;
        }

        public CrawlRulesBuilder addInvariant(Invariant ... invariant) {
            this.invariants.add((Object[])invariant);
            return this;
        }

        public CrawlRulesBuilder addInvariant(String description, Condition condition) {
            Preconditions.checkNotNull((Object)description);
            Preconditions.checkNotNull((Object)condition);
            this.invariants.add((Object)new Invariant(description, condition));
            return this;
        }

        public CrawlRulesBuilder addOracleComparator(OracleComparator ... oracle) {
            this.oracleComparators.add((Object[])oracle);
            return this;
        }

        public PreCrawlConfiguration.PreCrawlConfigurationBuilder addWaitCondition(WaitCondition ... condition) {
            return this.preCrawlConfig.addWaitCondition(condition);
        }

        public PreCrawlConfiguration.PreCrawlConfigurationBuilder addCrawlCondition(CrawlCondition ... condition) {
            return this.preCrawlConfig.addCrawlCondition(condition);
        }

        public PreCrawlConfiguration.PreCrawlConfigurationBuilder addCrawlCondition(String description, Condition crawlCondition) {
            return this.preCrawlConfig.addCrawlCondition(new CrawlCondition(description, crawlCondition));
        }

        public PreCrawlConfiguration.PreCrawlConfigurationBuilder filterAttributeNames(String names) {
            return this.preCrawlConfig.filterAttributeNames(names);
        }

        public CrawlRulesBuilder setInputSpec(InputSpecification spec) {
            Preconditions.checkNotNull((Object)spec);
            this.crawlRules.inputSpecification = spec;
            return this;
        }

        public CrawlRulesBuilder testInvariantsWhileCrawling(boolean test) {
            this.crawlRules.testInvariantsWhileCrawling = test;
            return this;
        }

        public CrawlRulesBuilder clickOnce(boolean once) {
            this.crawlRules.clickOnce = once;
            return this;
        }

        public CrawlRulesBuilder clickElementsInRandomOrder(boolean randomize) {
            this.crawlRules.randomizeCandidateElements = randomize;
            return this;
        }

        public CrawlRulesBuilder crawlFrames(boolean frames) {
            this.crawlRules.crawlFrames = frames;
            return this;
        }

        public CrawlRulesBuilder waitAfterReloadUrl(long time, TimeUnit unit) {
            Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (Object)"Wait after reload time should be larget than 0");
            this.crawlRules.waitAfterReloadUrl = unit.toMillis(time);
            return this;
        }

        public CrawlRulesBuilder waitAfterEvent(long time, TimeUnit unit) {
            Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (Object)"Wait after event time should be larget than 0");
            this.crawlRules.waitAfterEvent = unit.toMillis(time);
            return this;
        }

        public CrawlRulesBuilder crawlHiddenAnchors(boolean anchors) {
            this.crawlRules.crawlHiddenAnchors = anchors;
            return this;
        }

        public CrawlElement click(String tagName) {
            return this.crawlActionsBuilder.click(tagName);
        }

        public CrawlRulesBuilder click(String ... tagNames) {
            this.crawlActionsBuilder.click(tagNames);
            return this;
        }

        public CrawlRulesBuilder clickDefaultElements() {
            this.crawlActionsBuilder.clickDefaultElements();
            return this;
        }

        public CrawlElement dontClick(String tagName) {
            return this.crawlActionsBuilder.dontClick(tagName);
        }

        public CrawlActionsBuilder.ExcludeByParentBuilder dontClickChildrenOf(String tagname) {
            return this.crawlActionsBuilder.dontClickChildrenOf(tagname);
        }

        public CrawlRulesBuilder followExternalLinks(boolean follow) {
            this.crawlRules.followExternalLinks = follow;
            return this;
        }

        public CrawljaxConfiguration.CrawljaxConfigurationBuilder endRules() {
            return this.crawljaxBuilder;
        }

        CrawlRules build() {
            this.crawlRules.crawlEvents = this.crawlEvents.build();
            if (this.crawlRules.crawlEvents.isEmpty()) {
                this.crawlRules.crawlEvents = ImmutableSortedSet.of((Comparable)((Object)Eventable.EventType.click));
            }
            this.crawlRules.invariants = this.invariants.build();
            this.setupOracleComparatorsOrDefault();
            this.crawlRules.preCrawlConfig = this.preCrawlConfig.build(this.crawlActionsBuilder);
            this.crawlRules.ignoredFrameIdentifiers = this.ignoredFrameIdentifiers.build();
            return this.crawlRules;
        }

        private void setupOracleComparatorsOrDefault() {
            ImmutableList comparators = this.oracleComparators.build();
            if (comparators.isEmpty()) {
                this.crawlRules.oracleComparators = ImmutableList.of((Object)new OracleComparator("SimpleComparator", new SimpleComparator()));
            } else {
                this.crawlRules.oracleComparators = comparators;
            }
        }
    }
}

