/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.configuration.ProxyConfiguration;
import com.crawljax.core.plugin.Plugin;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;

public class CrawljaxConfiguration {
    private URL url;
    private BrowserConfiguration browserConfig = new BrowserConfiguration(EmbeddedBrowser.BrowserType.FIREFOX);
    private ImmutableList<Plugin> plugins;
    private ProxyConfiguration proxyConfiguration = ProxyConfiguration.noProxy();
    private CrawlRules crawlRules;
    private int maximumStates = 0;
    private long maximumRuntime = TimeUnit.HOURS.toMillis(1L);
    private int maximumDepth = 2;
    private File output = new File("out");

    public static CrawljaxConfigurationBuilder builderFor(URL url) {
        Preconditions.checkNotNull((Object)url, (Object)"URL was null");
        return new CrawljaxConfigurationBuilder(url);
    }

    public static CrawljaxConfigurationBuilder builderFor(String url) {
        try {
            return new CrawljaxConfigurationBuilder(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new CrawljaxException("Could not read that URL", e);
        }
    }

    private CrawljaxConfiguration() {
    }

    public URL getUrl() {
        return this.url;
    }

    public BrowserConfiguration getBrowserConfig() {
        return this.browserConfig;
    }

    public ImmutableList<Plugin> getPlugins() {
        return this.plugins;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public CrawlRules getCrawlRules() {
        return this.crawlRules;
    }

    public int getMaximumStates() {
        return this.maximumStates;
    }

    public long getMaximumRuntime() {
        return this.maximumRuntime;
    }

    public int getMaximumDepth() {
        return this.maximumDepth;
    }

    public File getOutputDir() {
        return this.output;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.url, this.browserConfig, this.plugins, this.proxyConfiguration, this.crawlRules, this.maximumStates, this.maximumRuntime, this.maximumDepth});
    }

    public boolean equals(Object object) {
        if (object instanceof CrawljaxConfiguration) {
            CrawljaxConfiguration that = (CrawljaxConfiguration)object;
            return Objects.equal((Object)this.url, (Object)that.url) && Objects.equal((Object)this.browserConfig, (Object)that.browserConfig) && Objects.equal(this.plugins, that.plugins) && Objects.equal((Object)this.proxyConfiguration, (Object)that.proxyConfiguration) && Objects.equal((Object)this.crawlRules, (Object)that.crawlRules) && Objects.equal((Object)this.maximumStates, (Object)that.maximumStates) && Objects.equal((Object)this.maximumRuntime, (Object)that.maximumRuntime) && Objects.equal((Object)this.maximumDepth, (Object)that.maximumDepth);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("url", (Object)this.url).add("browserConfig", (Object)this.browserConfig).add("plugins", this.plugins).add("proxyConfiguration", (Object)this.proxyConfiguration).add("crawlRules", (Object)this.crawlRules).add("maximumStates", this.maximumStates).add("maximumRuntime", this.maximumRuntime).add("maximumDepth", this.maximumDepth).toString();
    }

    public static class CrawljaxConfigurationBuilder {
        private final ImmutableList.Builder<Plugin> pluginBuilder = ImmutableList.builder();
        private final CrawljaxConfiguration config;
        private final CrawlRules.CrawlRulesBuilder crawlRules;

        private CrawljaxConfigurationBuilder(URL url) {
            Preconditions.checkNotNull((Object)url);
            this.config = new CrawljaxConfiguration();
            this.config.url = url;
            this.crawlRules = CrawlRules.builder(this);
        }

        public CrawljaxConfigurationBuilder setBasicAuth(String username, String password) {
            try {
                String encodedUsername = URLEncoder.encode(username, "UTF-8");
                String encodedPassword = URLEncoder.encode(password, "UTF-8");
                this.config.url = new URL(this.config.url.getProtocol() + "://" + encodedUsername + ":" + encodedPassword + "@" + this.config.url.getAuthority() + this.config.url.getPath());
                System.out.println("URL " + this.config.url);
            }
            catch (UnsupportedEncodingException | MalformedURLException e) {
                throw new CrawljaxException("Could not parse the username/password to a URL", e);
            }
            return this;
        }

        public CrawljaxConfigurationBuilder setMaximumStates(int states) {
            Preconditions.checkArgument((states > 1 ? 1 : 0) != 0, (Object)"Number of maximum states should be largen than 1");
            this.config.maximumStates = states;
            return this;
        }

        public CrawljaxConfigurationBuilder setUnlimitedStates() {
            this.config.maximumStates = 0;
            return this;
        }

        public CrawljaxConfigurationBuilder setMaximumRunTime(long time, TimeUnit unit) {
            Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (Object)"Time should be larger than 0, or 0 for infinate.");
            this.config.maximumRuntime = unit.toMillis(time);
            return this;
        }

        public CrawljaxConfigurationBuilder setUnlimitedRuntime() {
            this.config.maximumRuntime = 0L;
            return this;
        }

        public CrawljaxConfigurationBuilder setMaximumDepth(int depth) {
            Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"Depth should be 0 for infinite, or larger for a certain depth.");
            this.config.maximumDepth = depth;
            return this;
        }

        public CrawljaxConfigurationBuilder setUnlimitedCrawlDepth() {
            this.config.maximumDepth = 0;
            return this;
        }

        public CrawljaxConfigurationBuilder addPlugin(Plugin ... plugins) {
            this.pluginBuilder.add((Object[])plugins);
            return this;
        }

        public CrawljaxConfigurationBuilder setProxyConfig(ProxyConfiguration configuration) {
            Preconditions.checkNotNull((Object)configuration);
            this.config.proxyConfiguration = configuration;
            return this;
        }

        public CrawlRules.CrawlRulesBuilder crawlRules() {
            return this.crawlRules;
        }

        public CrawljaxConfigurationBuilder setBrowserConfig(BrowserConfiguration configuration) {
            Preconditions.checkNotNull((Object)configuration);
            this.config.browserConfig = configuration;
            return this;
        }

        public CrawljaxConfigurationBuilder setOutputDirectory(File output) {
            this.config.output = output;
            this.checkOutputDirWritable();
            return this;
        }

        private void checkOutputDirWritable() {
            if (!this.config.output.exists()) {
                Preconditions.checkState((boolean)this.config.output.mkdirs(), (String)"Could not create the output directory %s ", (Object[])new Object[]{this.config.output});
            } else {
                Preconditions.checkArgument((boolean)this.config.output.isDirectory(), (String)"Output directory %s is not a folder", (Object[])new Object[]{this.config.output});
                Preconditions.checkState((boolean)this.config.output.canWrite(), (String)"Output directory %s is not writable", (Object[])new Object[]{this.config.output});
            }
        }

        public CrawljaxConfiguration build() {
            this.config.plugins = this.pluginBuilder.build();
            this.config.crawlRules = this.crawlRules.build();
            return this.config;
        }
    }
}

