/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.core.configuration.CrawlElement;
import com.crawljax.core.configuration.FormAction;
import com.crawljax.core.configuration.FormInputField;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class Form {
    private final List<FormInputField> inputFields = new ArrayList<FormInputField>();
    private FormAction formAction;

    public FormInputField field(String fieldName) {
        FormInputField inputField = new FormInputField();
        inputField.setFieldName(fieldName);
        this.inputFields.add(inputField);
        return inputField;
    }

    protected ImmutableList<FormInputField> getInputFields() {
        return ImmutableList.copyOf(this.inputFields);
    }

    protected void setFormAction(FormAction formAction) {
        this.formAction = formAction;
    }

    protected FormAction getFormAction() {
        return this.formAction;
    }

    protected CrawlElement getCrawlElement() {
        CrawlElement crawlTag = this.formAction.getCrawlElement();
        ArrayList<String> inputFieldIds = new ArrayList<String>();
        for (FormInputField inputField : this.inputFields) {
            inputFieldIds.add(inputField.getId());
        }
        crawlTag.addInputFieldIds(inputFieldIds);
        return crawlTag;
    }

    protected void addInputField(FormInputField inputField) {
        this.inputFields.add(inputField);
    }

    public String toString() {
        return this.formAction.getCrawlElement().toString() + " sets " + this.inputFields.toString();
    }
}

