/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.core.configuration.CrawlElement;
import com.crawljax.core.configuration.Form;
import com.crawljax.core.configuration.FormAction;
import com.crawljax.core.configuration.FormInputField;
import com.crawljax.core.configuration.InputField;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import java.util.List;

public final class InputSpecification {
    private final List<InputField> inputFields = Lists.newLinkedList();
    private final List<Form> forms = Lists.newLinkedList();

    public InputField field(String fieldName) {
        InputField inputField = new InputField();
        inputField.setFieldName(fieldName);
        this.inputFields.add(inputField);
        return inputField;
    }

    public InputField fields(String ... fieldNames) {
        InputField inputField = new InputField();
        inputField.setFieldNames(fieldNames);
        this.inputFields.add(inputField);
        return inputField;
    }

    public FormAction setValuesInForm(Form form) {
        FormAction formAction = new FormAction();
        form.setFormAction(formAction);
        this.forms.add(form);
        return formAction;
    }

    public ImmutableListMultimap<String, String> getFormFieldNames() {
        ImmutableListMultimap.Builder formFieldNames = ImmutableListMultimap.builder();
        for (Form form : this.forms) {
            for (FormInputField inputField : form.getInputFields()) {
                formFieldNames.putAll((Object)inputField.getId(), inputField.getFieldNames());
            }
        }
        for (InputField inputField : this.inputFields) {
            formFieldNames.putAll((Object)inputField.getId(), inputField.getFieldNames());
        }
        return formFieldNames.build();
    }

    public ImmutableListMultimap<String, String> getFormFieldValues() {
        ImmutableListMultimap.Builder formFieldNames = ImmutableListMultimap.builder();
        for (Form form : this.forms) {
            for (FormInputField inputField : form.getInputFields()) {
                formFieldNames.putAll((Object)inputField.getId(), inputField.getFieldValues());
            }
        }
        for (InputField inputField : this.inputFields) {
            formFieldNames.putAll((Object)inputField.getId(), inputField.getFieldValues());
        }
        return formFieldNames.build();
    }

    public ImmutableList<CrawlElement> getCrawlElements() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Form form : this.forms) {
            CrawlElement crawlTag = form.getCrawlElement();
            if (crawlTag == null) continue;
            builder.add((Object)crawlTag);
        }
        return builder.build();
    }
}

