/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.condition.browserwaiter.WaitCondition;
import com.crawljax.condition.crawlcondition.CrawlCondition;
import com.crawljax.core.configuration.CrawlActionsBuilder;
import com.crawljax.core.configuration.CrawlElement;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import org.apache.commons.lang3.tuple.Pair;

public class PreCrawlConfiguration {
    private ImmutableList<WaitCondition> waitConditions;
    private ImmutableList<CrawlCondition> crawlConditions;
    private ImmutableList<CrawlElement> includedElements;
    private ImmutableList<CrawlElement> excludedElements;
    private ImmutableSortedSet<String> filterAttributeNames;

    public static PreCrawlConfigurationBuilder builder() {
        return new PreCrawlConfigurationBuilder();
    }

    private PreCrawlConfiguration() {
    }

    public ImmutableList<WaitCondition> getWaitConditions() {
        return this.waitConditions;
    }

    public ImmutableList<CrawlCondition> getCrawlConditions() {
        return this.crawlConditions;
    }

    public ImmutableList<CrawlElement> getIncludedElements() {
        return this.includedElements;
    }

    public ImmutableList<CrawlElement> getExcludedElements() {
        return this.excludedElements;
    }

    public ImmutableSortedSet<String> getFilterAttributeNames() {
        return this.filterAttributeNames;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("waitConditions", this.waitConditions).add("crawlConditions", this.crawlConditions).add("includedElements", this.includedElements).add("excludedElements", this.excludedElements).add("filterAttributeNames", this.filterAttributeNames).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.waitConditions, this.crawlConditions, this.includedElements, this.excludedElements, this.filterAttributeNames});
    }

    public boolean equals(Object object) {
        if (object instanceof PreCrawlConfiguration) {
            PreCrawlConfiguration that = (PreCrawlConfiguration)object;
            return Objects.equal(this.waitConditions, that.waitConditions) && Objects.equal(this.crawlConditions, that.crawlConditions) && Objects.equal(this.includedElements, that.includedElements) && Objects.equal(this.excludedElements, that.excludedElements) && Objects.equal(this.filterAttributeNames, that.filterAttributeNames);
        }
        return false;
    }

    public static class PreCrawlConfigurationBuilder {
        private final PreCrawlConfiguration preCrawlConfiguration;
        private final ImmutableList.Builder<WaitCondition> waitConditions = ImmutableList.builder();
        private final ImmutableList.Builder<CrawlCondition> crawlConditions = ImmutableList.builder();
        private final ImmutableSortedSet.Builder<String> filterAttributeNames = ImmutableSortedSet.naturalOrder();

        private PreCrawlConfigurationBuilder() {
            this.preCrawlConfiguration = new PreCrawlConfiguration();
        }

        public PreCrawlConfigurationBuilder addWaitCondition(WaitCondition ... condition) {
            this.waitConditions.add((Object[])condition);
            return this;
        }

        public PreCrawlConfigurationBuilder addCrawlCondition(CrawlCondition ... condition) {
            this.crawlConditions.add((Object[])condition);
            return this;
        }

        public PreCrawlConfigurationBuilder filterAttributeNames(String names) {
            this.filterAttributeNames.add((Object)names);
            return this;
        }

        PreCrawlConfiguration build(CrawlActionsBuilder crawlActionsBuilder) {
            Pair<ImmutableList<CrawlElement>, ImmutableList<CrawlElement>> elements = crawlActionsBuilder.build();
            this.preCrawlConfiguration.includedElements = (ImmutableList)elements.getLeft();
            this.preCrawlConfiguration.excludedElements = (ImmutableList)elements.getRight();
            this.preCrawlConfiguration.waitConditions = this.waitConditions.build();
            this.preCrawlConfiguration.crawlConditions = this.crawlConditions.build();
            this.preCrawlConfiguration.filterAttributeNames = this.filterAttributeNames.build();
            if (this.preCrawlConfiguration.filterAttributeNames.isEmpty()) {
                this.preCrawlConfiguration.filterAttributeNames = ImmutableSortedSet.of((Comparable)((Object)"closure_hashcode_(\\w)*"), (Comparable)((Object)"jquery[0-9]+"));
            }
            return this.preCrawlConfiguration;
        }
    }
}

