/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProxyConfiguration {
    private final int port;
    private final String hostname;
    private final ProxyType type;

    public static ProxyConfiguration noProxy() {
        return new ProxyConfiguration(-1, "none", ProxyType.NOTHING);
    }

    public static ProxyConfiguration automatic() {
        return new ProxyConfiguration(-1, "none", ProxyType.AUTOMATIC);
    }

    public static ProxyConfiguration systemDefault() {
        return new ProxyConfiguration(-1, "none", ProxyType.SYSTEM_DEFAULT);
    }

    public static ProxyConfiguration manualProxyOn(String host, int port) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkArgument((port > 0 && port <= 65535 ? 1 : 0) != 0, (Object)("port number should be between 0 and 65535 but was " + port));
        return new ProxyConfiguration(port, host, ProxyType.MANUAL);
    }

    private ProxyConfiguration(int port, String hostname, ProxyType type) {
        this.port = port;
        this.hostname = hostname;
        this.type = type;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public ProxyType getType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case MANUAL: {
                return "Manual host: " + this.hostname + ":" + this.port;
            }
        }
        return this.type.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.port, this.hostname, this.type});
    }

    public boolean equals(Object object) {
        if (object instanceof ProxyConfiguration) {
            ProxyConfiguration that = (ProxyConfiguration)object;
            return Objects.equal((Object)this.port, (Object)that.port) && Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
        }
        return false;
    }

    public static enum ProxyType {
        NOTHING(0),
        MANUAL(1),
        AUTOMATIC(4),
        SYSTEM_DEFAULT(5);

        private int value;

        private ProxyType(int value) {
            this.value = value;
        }

        public int toInt() {
            return this.value;
        }
    }
}

