/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.plugin;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.invariant.Invariant;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.DomChangeNotifierPlugin;
import com.crawljax.core.plugin.OnBrowserCreatedPlugin;
import com.crawljax.core.plugin.OnFireEventFailedPlugin;
import com.crawljax.core.plugin.OnInvariantViolationPlugin;
import com.crawljax.core.plugin.OnNewStatePlugin;
import com.crawljax.core.plugin.OnRevisitStatePlugin;
import com.crawljax.core.plugin.OnUrlLoadPlugin;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.plugin.PostCrawlingPlugin;
import com.crawljax.core.plugin.PreCrawlingPlugin;
import com.crawljax.core.plugin.PreStateCrawlingPlugin;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateVertex;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Plugins {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Plugins.class.getName());
    static final ImmutableSet<Class<? extends Plugin>> KNOWN_PLUGINS = ImmutableSet.of(DomChangeNotifierPlugin.class, OnBrowserCreatedPlugin.class, OnFireEventFailedPlugin.class, OnInvariantViolationPlugin.class, OnNewStatePlugin.class, OnRevisitStatePlugin.class, (Object[])new Class[]{OnUrlLoadPlugin.class, PostCrawlingPlugin.class, PreStateCrawlingPlugin.class, PreCrawlingPlugin.class});
    private final ImmutableListMultimap<Class<? extends Plugin>, Plugin> plugins;
    private final ImmutableMap<Class<? extends Plugin>, Counter> counters;
    private final MetricRegistry registry;

    @Inject
    public Plugins(CrawljaxConfiguration config, MetricRegistry registry) {
        this.registry = registry;
        ImmutableList<Plugin> plugins = config.getPlugins();
        Preconditions.checkNotNull(plugins);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        if (plugins.isEmpty()) {
            LOGGER.warn("No plugins loaded. There will be no output");
        } else {
            this.addPlugins((List<? extends Plugin>)plugins, (ImmutableListMultimap.Builder<Class<? extends Plugin>, Plugin>)builder);
        }
        this.plugins = builder.build();
        Preconditions.checkArgument((this.plugins.get(DomChangeNotifierPlugin.class).size() < 2 ? 1 : 0) != 0, (Object)("Only one or none " + DomChangeNotifierPlugin.class.getSimpleName() + " can be specified"));
        this.counters = this.registerCounters(registry);
    }

    private ImmutableMap<Class<? extends Plugin>, Counter> registerCounters(MetricRegistry registry) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class plugin : KNOWN_PLUGINS) {
            String name = "com.crawljax.crawlplugins." + plugin.getSimpleName() + ".invocations";
            Counter c = (Counter)registry.register(name, (Metric)new Counter());
            builder.put((Object)plugin, (Object)c);
        }
        return builder.build();
    }

    private void addPlugins(List<? extends Plugin> plugins, ImmutableListMultimap.Builder<Class<? extends Plugin>, Plugin> builder) {
        ArrayList unusedPlugins = Lists.newArrayList(plugins);
        for (Plugin plugin : plugins) {
            for (Class<?> clasz : plugin.getClass().getInterfaces()) {
                if (!KNOWN_PLUGINS.contains(clasz)) continue;
                Class<?> pluginclass = clasz;
                builder.put(pluginclass, (Object)plugin);
                LOGGER.info("Loaded {} as a {}", (Object)plugin, (Object)clasz.getSimpleName());
                unusedPlugins.remove(plugin);
            }
        }
        if (!unusedPlugins.isEmpty()) {
            LOGGER.warn("These plugins were added but are ignored because they are unkown to Crawljax, {}", (Object)unusedPlugins);
        }
    }

    private void reportFailingPlugin(Plugin plugin, RuntimeException e) {
        this.incrementFailCounterFor(plugin);
        LOGGER.error("Plugin {} errored while running. {}", new Object[]{plugin, e.getMessage(), e});
    }

    private void incrementFailCounterFor(Plugin plugin) {
        this.registry.counter("com.crawljax.crawlplugins." + plugin.getClass().getSimpleName() + ".fail_count").inc();
    }

    public void runOnUrlLoadPlugins(CrawlerContext context) {
        LOGGER.debug("Running OnUrlLoadPlugins...");
        ((Counter)this.counters.get(OnUrlLoadPlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(OnUrlLoadPlugin.class)) {
            if (!(plugin instanceof OnUrlLoadPlugin)) continue;
            try {
                LOGGER.debug("Calling plugin {}", (Object)plugin);
                ((OnUrlLoadPlugin)plugin).onUrlLoad(context);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public void runOnNewStatePlugins(CrawlerContext context, StateVertex newState) {
        LOGGER.debug("Running OnNewStatePlugins...");
        ((Counter)this.counters.get(OnNewStatePlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(OnNewStatePlugin.class)) {
            if (!(plugin instanceof OnNewStatePlugin)) continue;
            try {
                LOGGER.debug("Calling plugin {}", (Object)plugin);
                ((OnNewStatePlugin)plugin).onNewState(context, newState);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public void runOnInvariantViolationPlugins(Invariant invariant, CrawlerContext context) {
        LOGGER.debug("Running OnInvariantViolationPlugins...");
        ((Counter)this.counters.get(OnInvariantViolationPlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(OnInvariantViolationPlugin.class)) {
            if (!(plugin instanceof OnInvariantViolationPlugin)) continue;
            try {
                LOGGER.debug("Calling plugin {}", (Object)plugin);
                ((OnInvariantViolationPlugin)plugin).onInvariantViolation(invariant, context);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public void runPostCrawlingPlugins(CrawlSession session, ExitNotifier.ExitStatus exitReason) {
        LOGGER.debug("Running PostCrawlingPlugins...");
        ((Counter)this.counters.get(PostCrawlingPlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(PostCrawlingPlugin.class)) {
            if (!(plugin instanceof PostCrawlingPlugin)) continue;
            try {
                LOGGER.debug("Calling plugin {}", (Object)plugin);
                ((PostCrawlingPlugin)plugin).postCrawling(session, exitReason);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public void runOnRevisitStatePlugins(CrawlerContext context, StateVertex currentState) {
        LOGGER.debug("Running OnRevisitStatePlugins...");
        ((Counter)this.counters.get(OnRevisitStatePlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(OnRevisitStatePlugin.class)) {
            if (!(plugin instanceof OnRevisitStatePlugin)) continue;
            LOGGER.debug("Calling plugin {}", (Object)plugin);
            try {
                ((OnRevisitStatePlugin)plugin).onRevisitState(context, currentState);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public void runPreStateCrawlingPlugins(CrawlerContext context, ImmutableList<CandidateElement> candidateElements, StateVertex state) {
        LOGGER.debug("Running PreStateCrawlingPlugins...");
        ((Counter)this.counters.get(PreStateCrawlingPlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(PreStateCrawlingPlugin.class)) {
            if (!(plugin instanceof PreStateCrawlingPlugin)) continue;
            LOGGER.debug("Calling plugin {}", (Object)plugin);
            try {
                ((PreStateCrawlingPlugin)plugin).preStateCrawling(context, candidateElements, state);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public void runPreCrawlingPlugins(CrawljaxConfiguration config) {
        LOGGER.debug("Running PreCrawlingPlugins...");
        ((Counter)this.counters.get(PreStateCrawlingPlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(PreCrawlingPlugin.class)) {
            if (!(plugin instanceof PreCrawlingPlugin)) continue;
            LOGGER.debug("Calling plugin {}", (Object)plugin);
            try {
                ((PreCrawlingPlugin)plugin).preCrawling(config);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public void runOnFireEventFailedPlugins(CrawlerContext context, Eventable eventable, List<Eventable> path) {
        LOGGER.debug("Running OnFireEventFailedPlugins...");
        ((Counter)this.counters.get(OnFireEventFailedPlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(OnFireEventFailedPlugin.class)) {
            if (!(plugin instanceof OnFireEventFailedPlugin)) continue;
            LOGGER.debug("Calling plugin {}", (Object)plugin);
            try {
                ((OnFireEventFailedPlugin)plugin).onFireEventFailed(context, eventable, path);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public void runOnBrowserCreatedPlugins(EmbeddedBrowser newBrowser) {
        LOGGER.debug("Running OnBrowserCreatedPlugins...");
        ((Counter)this.counters.get(OnBrowserCreatedPlugin.class)).inc();
        for (Plugin plugin : this.plugins.get(OnBrowserCreatedPlugin.class)) {
            if (!(plugin instanceof OnBrowserCreatedPlugin)) continue;
            LOGGER.debug("Calling plugin {}", (Object)plugin);
            try {
                ((OnBrowserCreatedPlugin)plugin).onBrowserCreated(newBrowser);
            }
            catch (RuntimeException e) {
                this.reportFailingPlugin(plugin, e);
            }
        }
    }

    public boolean runDomChangeNotifierPlugins(CrawlerContext context, StateVertex stateBefore, Eventable event, StateVertex stateAfter) {
        ((Counter)this.counters.get(DomChangeNotifierPlugin.class)).inc();
        if (this.plugins.get(DomChangeNotifierPlugin.class).isEmpty()) {
            LOGGER.debug("No DomChangeNotifierPlugin found. Performing default DOM comparison...");
            return this.defaultDomComparison(stateBefore, stateAfter);
        }
        DomChangeNotifierPlugin domChange = (DomChangeNotifierPlugin)this.plugins.get(DomChangeNotifierPlugin.class).get(0);
        LOGGER.debug("Calling plugin {}", (Object)domChange);
        try {
            return domChange.isDomChanged(context, stateBefore.getDom(), event, stateAfter.getDom());
        }
        catch (RuntimeException ex) {
            LOGGER.error("Could not run {} because of error {}. Now running default DOM comparison", new Object[]{domChange, ex.getMessage(), ex});
            this.incrementFailCounterFor(domChange);
            return this.defaultDomComparison(stateBefore, stateAfter);
        }
    }

    private boolean defaultDomComparison(StateVertex stateBefore, StateVertex stateAfter) {
        boolean isChanged;
        boolean bl = isChanged = !stateAfter.equals(stateBefore);
        if (isChanged) {
            LOGGER.debug("Dom is Changed!");
            return true;
        }
        LOGGER.debug("Dom not Changed!");
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.plugins});
    }

    public boolean equals(Object object) {
        if (object instanceof Plugins) {
            Plugins that = (Plugins)object;
            return Objects.equal(this.plugins, that.plugins);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("plugins", this.plugins).toString();
    }

    public ImmutableSet<String> pluginNames() {
        ImmutableSortedSet.Builder names = ImmutableSortedSet.naturalOrder();
        for (Plugin plugin : this.plugins.values()) {
            names.add((Object)plugin.toString());
        }
        return names.build();
    }
}

