/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.state.Eventable;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CrawlPath
extends ForwardingList<Eventable> {
    private final List<Eventable> eventablePath;

    public static CrawlPath copyOf(List<Eventable> eventable) {
        return new CrawlPath(Lists.newLinkedList(eventable));
    }

    public CrawlPath() {
        this(Lists.newLinkedList());
    }

    public CrawlPath(List<Eventable> delegate) {
        this.eventablePath = delegate;
    }

    protected List<Eventable> delegate() {
        return this.eventablePath;
    }

    public Eventable last() {
        if (this.eventablePath.isEmpty()) {
            return null;
        }
        return this.eventablePath.get(this.eventablePath.size() - 1);
    }

    public CrawlPath immutableCopy() {
        return this.immutableCopy(false);
    }

    public CrawlPath immutableCopyWithoutLast() {
        return this.immutableCopy(true);
    }

    private CrawlPath immutableCopy(boolean removeLast) {
        if (this.isEmpty()) {
            return new CrawlPath();
        }
        ArrayList path = Lists.newArrayList((Iterable)((Object)this));
        if (removeLast) {
            path.remove(path.size() - 1);
        }
        return new CrawlPath((List<Eventable>)ImmutableList.copyOf((Collection)path));
    }

    public StackTraceElement[] asStackTrace() {
        int i = 1;
        StackTraceElement[] list = new StackTraceElement[this.size()];
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Eventable e = (Eventable)i$.next();
            list[this.size() - i] = new StackTraceElement(e.getEventType().toString(), e.getIdentification().toString(), e.getElement().toString(), i);
            ++i;
        }
        return list;
    }
}

