/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.util.DomUtils;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Node;

@Immutable
public class Element
implements Serializable {
    private static final long serialVersionUID = -1608999189549530008L;
    private final Node node;
    private final String tag;
    private final String text;
    private final ImmutableMap<String, String> attributes;

    public Element(Node node) {
        Preconditions.checkNotNull((Object)node);
        this.node = node;
        this.tag = node.getNodeName();
        this.text = node.getTextContent() == null ? "" : DomUtils.removeNewLines(node.getTextContent()).trim();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node attr = node.getAttributes().item(i);
            builder.put((Object)attr.getNodeName().toLowerCase(), (Object)attr.getNodeValue());
        }
        this.attributes = builder.build();
    }

    public boolean equalAttributes(Element otherElement) {
        return this.getAttributes().equals(otherElement.getAttributes());
    }

    public boolean equalId(Element otherElement) {
        if (this.getElementId() == null || otherElement.getElementId() == null) {
            return false;
        }
        return this.getElementId().equalsIgnoreCase(otherElement.getElementId());
    }

    public boolean equalText(Element otherElement) {
        return this.getText().equalsIgnoreCase(otherElement.getText());
    }

    public String getElementId() {
        for (Map.Entry attribute : this.attributes.entrySet()) {
            if (!((String)attribute.getKey()).equalsIgnoreCase("id")) continue;
            return (String)attribute.getValue();
        }
        return null;
    }

    public String getTag() {
        return this.tag;
    }

    public String getText() {
        return this.text;
    }

    public String getAttributeOrNull(String attribute) {
        return (String)this.attributes.get((Object)attribute.toLowerCase());
    }

    public Node getNode() {
        return this.node;
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("node", (Object)this.node).add("tag", (Object)this.tag).add("text", (Object)this.text).add("attributes", this.attributes).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.node.toString(), this.tag, this.text, this.attributes});
    }

    public boolean equals(Object object) {
        if (object instanceof Element) {
            Element that = (Element)object;
            return Objects.equal((Object)this.node.toString(), (Object)that.node.toString()) && Objects.equal((Object)this.tag, (Object)that.tag) && Objects.equal((Object)this.text, (Object)that.text) && Objects.equal(this.attributes, that.attributes);
        }
        return false;
    }
}

