/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.CandidateElement;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.state.Element;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.StateVertex;
import com.crawljax.forms.FormInput;
import com.crawljax.util.XPathHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgrapht.graph.DefaultEdge;
import org.w3c.dom.Node;

public class Eventable
extends DefaultEdge
implements Serializable {
    private static final long serialVersionUID = 3229708706467350994L;
    private long id;
    private EventType eventType;
    private Identification identification;
    private Element element;
    private CopyOnWriteArrayList<FormInput> relatedFormInputs = new CopyOnWriteArrayList();
    private String relatedFrame = "";

    public Eventable() {
    }

    public Eventable(Identification identification, EventType eventType) {
        this.identification = identification;
        this.eventType = eventType;
    }

    public Eventable(Identification identification, EventType eventType, String relatedFrame) {
        this(identification, eventType);
        this.relatedFrame = relatedFrame;
    }

    public Eventable(Node node, EventType eventType) {
        this(new Identification(Identification.How.xpath, XPathHelper.getXPathExpression(node)), eventType);
        this.element = new Element(node);
    }

    public Eventable(CandidateElement candidateElement, EventType eventType) {
        this(candidateElement.getIdentification(), eventType);
        if (candidateElement.getElement() != null) {
            this.element = new Element(candidateElement.getElement());
        }
        this.relatedFormInputs = new CopyOnWriteArrayList<FormInput>(candidateElement.getFormInputs());
        this.relatedFrame = candidateElement.getRelatedFrame();
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public void setIdentification(Identification identification) {
        this.identification = identification;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public CopyOnWriteArrayList<FormInput> getRelatedFormInputs() {
        return this.relatedFormInputs;
    }

    public void setRelatedFormInputs(CopyOnWriteArrayList<FormInput> relatedFormInputs) {
        this.relatedFormInputs = relatedFormInputs;
    }

    public StateVertex getSourceStateVertex() {
        return (StateVertex)this.getSource();
    }

    public StateVertex getTargetStateVertex() {
        return (StateVertex)this.getTarget();
    }

    public String getRelatedFrame() {
        return this.relatedFrame;
    }

    @VisibleForTesting
    void setSource(StateVertex source) {
        this.setField("source", source);
    }

    private void setField(String fieldName, StateVertex source) {
        Class superclass = Eventable.class.getSuperclass().getSuperclass();
        try {
            Field f = superclass.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(this, source);
        }
        catch (ReflectiveOperationException e) {
            throw new CrawljaxException("Could not set the source field", e);
        }
    }

    @VisibleForTesting
    void setTarget(StateVertex target) {
        this.setField("target", target);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("eventType", (Object)this.eventType).add("identification", (Object)this.identification).add("element", (Object)this.element).add("source", this.getSource()).add("target", this.getTarget()).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.eventType, this.identification, this.element, this.getSource(), this.getTarget()});
    }

    public boolean equals(Object object) {
        if (object instanceof Eventable) {
            Eventable that = (Eventable)object;
            return Objects.equal((Object)((Object)this.eventType), (Object)((Object)that.eventType)) && Objects.equal((Object)this.identification, (Object)that.identification) && Objects.equal((Object)this.element, (Object)that.element) && Objects.equal((Object)this.getSource(), (Object)that.getSource()) && Objects.equal((Object)this.getTarget(), (Object)that.getTarget());
        }
        return false;
    }

    public static enum EventType {
        click,
        hover;

    }
}

