/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.ExitNotifier;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.jgrapht.DirectedGraph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.graph.DirectedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InMemoryStateFlowGraph
implements Serializable,
StateFlowGraph {
    private static final Logger LOG = LoggerFactory.getLogger((String)InMemoryStateFlowGraph.class.getName());
    private final DirectedGraph<StateVertex, Eventable> sfg;
    private final Lock readLock;
    private final Lock writeLock;
    private final AtomicInteger stateCounter = new AtomicInteger();
    private final AtomicInteger nextStateNameCounter = new AtomicInteger();
    private final ConcurrentMap<Integer, StateVertex> stateById;
    private final ExitNotifier exitNotifier;

    @Inject
    public InMemoryStateFlowGraph(ExitNotifier exitNotifier) {
        this.exitNotifier = exitNotifier;
        this.sfg = new DirectedMultigraph(Eventable.class);
        this.stateById = Maps.newConcurrentMap();
        LOG.debug("Initialized the stateflowgraph");
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public StateVertex putIfAbsent(StateVertex stateVertix) {
        return this.putIfAbsent(stateVertix, true);
    }

    public StateVertex putIndex(StateVertex index) {
        return this.putIfAbsent(index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateVertex putIfAbsent(StateVertex stateVertix, boolean correctName) {
        this.writeLock.lock();
        try {
            boolean added = this.sfg.addVertex((Object)stateVertix);
            if (added) {
                this.stateById.put(stateVertix.getId(), stateVertix);
                int count = this.stateCounter.incrementAndGet();
                this.exitNotifier.incrementNumberOfStates();
                LOG.debug("Number of states is now {}", (Object)count);
                StateVertex stateVertex = null;
                return stateVertex;
            }
            LOG.debug("Graph already contained vertex {}", (Object)stateVertix);
            StateVertex stateVertex = this.getStateInGraph(stateVertix);
            return stateVertex;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public StateVertex getById(int id) {
        return (StateVertex)this.stateById.get(id);
    }

    @Override
    public StateVertex getInitialState() {
        return (StateVertex)this.stateById.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEdge(StateVertex sourceVert, StateVertex targetVert, Eventable clickable) {
        clickable.setSource(sourceVert);
        clickable.setTarget(targetVert);
        this.writeLock.lock();
        try {
            boolean bl = this.sfg.addEdge((Object)sourceVert, (Object)targetVert, (Object)clickable);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock.lock();
        try {
            String string = this.sfg.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSet<Eventable> getOutgoingClickables(StateVertex stateVertix) {
        this.readLock.lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.sfg.outgoingEdgesOf((Object)stateVertix));
            return immutableSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSet<Eventable> getIncomingClickable(StateVertex stateVertix) {
        this.readLock.lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.sfg.incomingEdgesOf((Object)stateVertix));
            return immutableSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canGoTo(StateVertex source, StateVertex target) {
        this.readLock.lock();
        try {
            boolean bl = this.sfg.containsEdge((Object)source, (Object)target) || this.sfg.containsEdge((Object)target, (Object)source);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableList<Eventable> getShortestPath(StateVertex start, StateVertex end) {
        this.readLock.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf((Collection)DijkstraShortestPath.findPathBetween(this.sfg, (Object)start, (Object)end));
            return immutableList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSet<StateVertex> getAllStates() {
        this.readLock.lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.sfg.vertexSet());
            return immutableSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSet<Eventable> getAllEdges() {
        this.readLock.lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.sfg.edgeSet());
            return immutableSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateVertex getStateInGraph(StateVertex state) {
        this.readLock.lock();
        try {
            for (StateVertex st : this.sfg.vertexSet()) {
                if (!state.equals(st)) continue;
                StateVertex stateVertex = st;
                return stateVertex;
            }
            StateVertex stateVertex = null;
            return stateVertex;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMeanStateStringSize() {
        this.readLock.lock();
        try {
            Mean mean = new Mean();
            for (StateVertex state : this.sfg.vertexSet()) {
                mean.increment((double)state.getDom().getBytes().length);
            }
            int n = (int)mean.getResult();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getNumberOfStates() {
        return this.stateCounter.get();
    }

    StateVertex newStateFor(String url, String dom, String strippedDom) {
        int id = this.nextStateNameCounter.incrementAndGet();
        return new StateVertexImpl(id, url, this.getNewStateName(id), dom, strippedDom);
    }

    private String getNewStateName(int id) {
        return "state" + id;
    }

    @Override
    public List<List<GraphPath<StateVertex, Eventable>>> getAllPossiblePaths(StateVertex index) {
        ArrayList results = Lists.newArrayList();
        KShortestPaths kPaths = new KShortestPaths(this.sfg, (Object)index, Integer.MAX_VALUE);
        for (StateVertex state : this.getDeepStates(index)) {
            List paths = kPaths.getPaths((Object)state);
            results.add(paths);
        }
        return results;
    }

    private List<StateVertex> getDeepStates(StateVertex state) {
        ArrayList<StateVertex> deepStates = new ArrayList<StateVertex>();
        this.traverse(Sets.newHashSet(), deepStates, state);
        return deepStates;
    }

    private void traverse(Set<String> visitedStates, List<StateVertex> deepStates, StateVertex state) {
        visitedStates.add(state.getName());
        ImmutableSet<StateVertex> outgoingSet = this.getOutgoingStates(state);
        if (outgoingSet == null || outgoingSet.isEmpty()) {
            deepStates.add(state);
        } else if (this.cyclic(visitedStates, (Set<StateVertex>)outgoingSet)) {
            deepStates.add(state);
        } else {
            for (StateVertex st : outgoingSet) {
                if (visitedStates.contains(st.getName())) continue;
                this.traverse(visitedStates, deepStates, st);
            }
        }
    }

    private boolean cyclic(Set<String> visitedStates, Set<StateVertex> outgoingSet) {
        int i = 0;
        for (StateVertex state : outgoingSet) {
            if (!visitedStates.contains(state.getName())) continue;
            ++i;
        }
        return i == outgoingSet.size();
    }

    @Override
    public ImmutableSet<StateVertex> getOutgoingStates(StateVertex stateVertix) {
        HashSet<Object> result = new HashSet<Object>();
        for (Eventable c : this.getOutgoingClickables(stateVertix)) {
            result.add(this.sfg.getEdgeTarget((Object)c));
        }
        return ImmutableSet.copyOf(result);
    }
}

