/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.ConditionTypeChecker;
import com.crawljax.condition.invariant.Invariant;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexImpl;
import com.crawljax.oraclecomparator.StateComparator;
import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)StateMachine.class.getName());
    private final InMemoryStateFlowGraph stateFlowGraph;
    private final StateVertex initialState;
    private StateVertex currentState;
    private final ConditionTypeChecker<Invariant> invariantChecker;
    private final Plugins plugins;
    private final StateComparator stateComparator;

    public static StateVertex createIndex(String url, String dom, String strippedDom) {
        return new StateVertexImpl(0, url, "index", dom, strippedDom);
    }

    public StateMachine(InMemoryStateFlowGraph sfg, ImmutableList<Invariant> invariantList, Plugins plugins, StateComparator stateComparator) {
        this.stateFlowGraph = sfg;
        this.initialState = sfg.getInitialState();
        this.plugins = plugins;
        this.stateComparator = stateComparator;
        this.currentState = this.initialState;
        this.invariantChecker = new ConditionTypeChecker<Invariant>(invariantList);
    }

    public StateVertex newStateFor(EmbeddedBrowser browser) {
        return this.stateFlowGraph.newStateFor(browser.getCurrentUrl(), browser.getStrippedDom(), this.stateComparator.getStrippedDom(browser));
    }

    public boolean changeState(StateVertex nextState) {
        if (nextState == null) {
            LOGGER.info("nextState given is null");
            return false;
        }
        LOGGER.debug("Trying to change to state: '{}' from: '{}'", (Object)nextState.getName(), (Object)this.currentState.getName());
        if (this.stateFlowGraph.canGoTo(this.currentState, nextState)) {
            LOGGER.debug("Changed to state: '{}' from: '{}'", (Object)nextState.getName(), (Object)this.currentState.getName());
            this.currentState = nextState;
            return true;
        }
        LOGGER.info("Cannot go to state: '{}' from: '{}'", (Object)nextState.getName(), (Object)this.currentState.getName());
        return false;
    }

    private StateVertex addStateToCurrentState(StateVertex newState, Eventable eventable) {
        LOGGER.debug("addStateToCurrentState currentState: {} newstate {}", (Object)this.currentState.getName(), (Object)newState.getName());
        StateVertex cloneState = this.stateFlowGraph.putIfAbsent(newState);
        if (cloneState != null) {
            LOGGER.info("CLONE State detected: {} and {} are the same.", (Object)newState.getName(), (Object)cloneState.getName());
            LOGGER.debug("CLONE CURRENTSTATE: {}", (Object)this.currentState.getName());
            LOGGER.debug("CLONE STATE: {}", (Object)cloneState.getName());
            LOGGER.debug("CLONE CLICKABLE: {}", (Object)eventable);
            this.stateFlowGraph.addEdge(this.currentState, cloneState, eventable);
        } else {
            this.stateFlowGraph.addEdge(this.currentState, newState, eventable);
            LOGGER.info("State {} added to the StateMachine.", (Object)newState.getName());
        }
        return cloneState;
    }

    public StateVertex getCurrentState() {
        return this.currentState;
    }

    public void rewind() {
        this.currentState = this.initialState;
    }

    public boolean swithToStateAndCheckIfClone(Eventable event, StateVertex newState, CrawlerContext context) {
        StateVertex cloneState = this.addStateToCurrentState(newState, event);
        this.runOnInvariantViolationPlugins(context);
        if (cloneState == null) {
            this.changeState(newState);
            this.plugins.runOnNewStatePlugins(context, newState);
            return true;
        }
        this.changeState(cloneState);
        return false;
    }

    private void runOnInvariantViolationPlugins(CrawlerContext context) {
        for (Invariant failedInvariant : this.invariantChecker.getFailedConditions(context.getBrowser())) {
            this.plugins.runOnInvariantViolationPlugins(failedInvariant, context);
        }
    }
}

