/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.CandidateElement;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateVertex;
import com.crawljax.util.DomUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.w3c.dom.Document;

class StateVertexImpl
implements StateVertex {
    private static final long serialVersionUID = 123400017983488L;
    private final Collection<Eventable> foundEventables;
    private final int id;
    private final String dom;
    private final String strippedDom;
    private final String url;
    private String name;
    private ImmutableList<CandidateElement> candidateElements;

    @VisibleForTesting
    StateVertexImpl(int id, String name, String dom) {
        this(id, null, name, dom, dom);
    }

    public StateVertexImpl(int id, String url, String name, String dom, String strippedDom) {
        this.id = id;
        this.url = url;
        this.name = name;
        this.dom = dom;
        this.strippedDom = strippedDom;
        this.foundEventables = Queues.newConcurrentLinkedQueue();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDom() {
        return this.dom;
    }

    @Override
    public String getStrippedDom() {
        return this.strippedDom;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.strippedDom});
    }

    public boolean equals(Object object) {
        if (object instanceof StateVertex) {
            StateVertex that = (StateVertex)object;
            return Objects.equal((Object)this.strippedDom, (Object)that.getStrippedDom());
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).toString();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Document getDocument() throws IOException {
        return DomUtils.asDocument(this.dom);
    }

    public void registerEventable(Eventable eventable) {
        this.foundEventables.add(eventable);
    }

    @Override
    public void setElementsFound(LinkedList<CandidateElement> elements) {
        this.candidateElements = ImmutableList.copyOf(elements);
    }

    @Override
    public ImmutableList<CandidateElement> getCandidateElements() {
        return this.candidateElements;
    }
}

