/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.di;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.browser.WebDriverBrowserBuilder;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.configuration.ProxyConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.util.Providers;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;

public class ConfigurationModule
extends AbstractModule {
    private final CrawljaxConfiguration config;

    public ConfigurationModule(CrawljaxConfiguration config) {
        this.config = config;
    }

    protected void configure() {
        this.bind(URL.class).annotatedWith(BaseUrl.class).toInstance((Object)this.config.getUrl());
        this.bind(CrawljaxConfiguration.class).toInstance((Object)this.config);
        this.bind(CrawlRules.class).toInstance((Object)this.config.getCrawlRules());
        this.bind(ProxyConfiguration.class).toInstance((Object)this.config.getProxyConfiguration());
        BrowserConfiguration browserConfig = this.config.getBrowserConfig();
        this.bind(BrowserConfiguration.class).toInstance((Object)browserConfig);
        if (browserConfig.isDefaultBuilder()) {
            this.bind(EmbeddedBrowser.class).toProvider(WebDriverBrowserBuilder.class);
        } else {
            this.bind(EmbeddedBrowser.class).toProvider(Providers.guicify(browserConfig.getBrowserBuilder()));
        }
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BaseUrl {
    }
}

