/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.di;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.ConditionTypeChecker;
import com.crawljax.condition.crawlcondition.CrawlCondition;
import com.crawljax.core.CandidateElementExtractor;
import com.crawljax.core.CandidateElementManager;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.ExtractorManager;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.di.ConfigurationModule;
import com.crawljax.di.CrawlSessionProvider;
import com.crawljax.forms.FormHandler;
import com.crawljax.metrics.MetricsModule;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(CoreModule.class);
    private CrawljaxConfiguration configuration;

    public CoreModule(CrawljaxConfiguration config) {
        this.configuration = config;
    }

    protected void configure() {
        LOG.debug("Configuring the core module");
        this.install(new MetricsModule());
        this.install((Module)new ConfigurationModule(this.configuration));
        this.bind(ExitNotifier.class).toInstance((Object)new ExitNotifier(this.configuration.getMaximumStates()));
        this.bind(ExecutorService.class).toInstance((Object)Executors.newCachedThreadPool());
        this.bind(CrawlSession.class).toProvider(CrawlSessionProvider.class);
        this.bind(ExtractorManager.class).to(CandidateElementManager.class);
        this.bind(StateFlowGraph.class).to(InMemoryStateFlowGraph.class);
        this.bind(InMemoryStateFlowGraph.class).in(Singleton.class);
        this.install(new FactoryModuleBuilder().build(FormHandlerFactory.class));
        this.install(new FactoryModuleBuilder().build(CandidateElementExtractorFactory.class));
    }

    @Provides
    ConditionTypeChecker<CrawlCondition> crawlConditionChecker() {
        return new ConditionTypeChecker<CrawlCondition>(this.configuration.getCrawlRules().getPreCrawlConfig().getCrawlConditions());
    }

    public static interface CandidateElementExtractorFactory {
        public CandidateElementExtractor newExtractor(EmbeddedBrowser var1);
    }

    public static interface FormHandlerFactory {
        public FormHandler newFormHandler(EmbeddedBrowser var1);
    }
}

