/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.di;

import com.codahale.metrics.MetricRegistry;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawlSessionNotSetupYetException;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CrawlSessionProvider
implements Provider<CrawlSession> {
    private static final Logger LOG = LoggerFactory.getLogger(CrawlSessionProvider.class);
    private final AtomicBoolean isSet = new AtomicBoolean();
    private final InMemoryStateFlowGraph stateFlowGraph;
    private final CrawljaxConfiguration config;
    private final MetricRegistry registry;
    private CrawlSession session;

    @Inject
    public CrawlSessionProvider(InMemoryStateFlowGraph stateFlowGraph, CrawljaxConfiguration config, MetricRegistry registry) {
        this.stateFlowGraph = stateFlowGraph;
        this.config = config;
        this.registry = registry;
    }

    public void setup(StateVertex indexState) {
        if (this.isSet.getAndSet(true)) {
            throw new IllegalStateException("Session is already set");
        }
        LOG.debug("Setting up the crawlsession");
        StateVertex added = this.stateFlowGraph.putIndex(indexState);
        Preconditions.checkArgument((added == null ? 1 : 0) != 0, (Object)"Could not set the initial state");
        this.session = new CrawlSession(this.config, this.stateFlowGraph, indexState, this.registry);
    }

    public CrawlSession get() {
        if (this.isSet.get()) {
            return this.session;
        }
        throw new CrawlSessionNotSetupYetException();
    }
}

