/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.forms;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.eventablecondition.EventableCondition;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.exception.BrowserConnectionException;
import com.crawljax.forms.FormInput;
import com.crawljax.forms.FormInputValueHelper;
import com.crawljax.forms.InputValue;
import com.crawljax.util.DomUtils;
import com.crawljax.util.XPathHelper;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FormHandler.class.getName());
    private boolean randomFieldValue = false;
    private final EmbeddedBrowser browser;
    public static final int RANDOM_STRING_LENGTH = 8;
    private static final double HALF = 0.5;
    private final FormInputValueHelper formInputValueHelper;
    private static final String[] ALLOWED_INPUT_TYPES = new String[]{"text", "radio", "checkbox", "password"};

    @Inject
    public FormHandler(@Assisted EmbeddedBrowser browser, CrawlRules config) {
        this.browser = browser;
        this.formInputValueHelper = new FormInputValueHelper(config.getInputSpecification(), config.isRandomInputInForms());
    }

    private void setInputElementValue(Node element, FormInput input) {
        LOGGER.debug("INPUTFIELD: {} ({})", (Object)input.getIdentification(), (Object)input.getType());
        if (element == null || input.getInputValues().isEmpty()) {
            return;
        }
        try {
            if (input.getType().toLowerCase().startsWith("text") || input.getType().equalsIgnoreCase("password") || input.getType().equalsIgnoreCase("hidden")) {
                this.handleText(element, input);
            } else if ("checkbox".equals(input.getType())) {
                this.handleCheckBoxes(element, input);
            } else if (input.getType().equals("radio")) {
                this.handleRadioSwitches(element, input);
            } else if (input.getType().startsWith("select")) {
                this.handleSelectBoxes(element, input);
            }
        }
        catch (BrowserConnectionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.error("Could not input element values", (Throwable)e);
        }
    }

    private void handleCheckBoxes(Node element, FormInput input) {
        for (InputValue inputValue : input.getInputValues()) {
            String js = DomUtils.getJSGetElement(XPathHelper.getXPathExpression(element));
            boolean check = !this.randomFieldValue ? inputValue.isChecked() : Math.random() >= 0.5;
            String value = check ? "true" : "false";
            js = js + "try{ATUSA_element.checked=" + value + ";}catch(e){}";
            this.browser.executeJavaScript(js);
        }
    }

    private void handleRadioSwitches(Node element, FormInput input) {
        for (InputValue inputValue : input.getInputValues()) {
            if (!inputValue.isChecked()) continue;
            String js = DomUtils.getJSGetElement(XPathHelper.getXPathExpression(element));
            js = js + "try{ATUSA_element.checked=true;}catch(e){}";
            this.browser.executeJavaScript(js);
        }
    }

    private void handleSelectBoxes(Node element, FormInput input) {
        for (InputValue inputValue : input.getInputValues()) {
            String js = DomUtils.getJSGetElement(XPathHelper.getXPathExpression(element));
            js = js + "try{for(i=0; i<ATUSA_element.options.length; i++){if(ATUSA_element.options[i].value=='" + inputValue.getValue() + "' || ATUSA_element.options[i].text=='" + inputValue.getValue() + "'){" + "ATUSA_element.options[i].selected=true;" + "break;" + "}" + "};" + "}catch(e){}";
            this.browser.executeJavaScript(js);
        }
    }

    private void handleText(Node element, FormInput input) {
        String text = input.getInputValues().iterator().next().getValue();
        if ("".equals(text)) {
            return;
        }
        String js = DomUtils.getJSGetElement(XPathHelper.getXPathExpression(element));
        js = js + "try{ATUSA_element.value='" + text + "';}catch(e){}";
        this.browser.executeJavaScript(js);
    }

    private List<Node> getInputElements(Document dom) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            int i;
            NodeList nodeList = XPathHelper.evaluateXpathExpression(dom, "//INPUT");
            ArrayList<String> allowedTypes = new ArrayList<String>(Arrays.asList(ALLOWED_INPUT_TYPES));
            for (i = 0; i < nodeList.getLength(); ++i) {
                Node candidate = nodeList.item(i);
                Node typeAttribute = candidate.getAttributes().getNamedItem("type");
                if (typeAttribute != null && !allowedTypes.contains(typeAttribute.getNodeValue())) continue;
                nodes.add(nodeList.item(i));
            }
            nodeList = XPathHelper.evaluateXpathExpression(dom, "//TEXTAREA");
            for (i = 0; i < nodeList.getLength(); ++i) {
                nodes.add(nodeList.item(i));
            }
            nodeList = XPathHelper.evaluateXpathExpression(dom, "//SELECT");
            for (i = 0; i < nodeList.getLength(); ++i) {
                nodes.add(nodeList.item(i));
            }
            return nodes;
        }
        catch (XPathExpressionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return nodes;
        }
    }

    public List<FormInput> getFormInputs() {
        ArrayList<FormInput> formInputs = new ArrayList<FormInput>();
        try {
            Document dom = DomUtils.asDocument(this.browser.getStrippedDom());
            List<Node> nodes = this.getInputElements(dom);
            for (Node node : nodes) {
                FormInput formInput = this.formInputValueHelper.getFormInputWithDefaultValue(this.browser, node);
                if (formInput == null) continue;
                formInputs.add(formInput);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return formInputs;
    }

    public void handleFormElements() throws Exception {
        this.handleFormElements(this.getFormInputs());
    }

    public void handleFormElements(List<FormInput> formInputs) {
        try {
            Document dom = DomUtils.asDocument(this.browser.getStrippedDomWithoutIframeContent());
            for (FormInput input : formInputs) {
                LOGGER.debug("Filling in: " + input);
                this.setInputElementValue(this.formInputValueHelper.getBelongingNode(input, dom), input);
            }
        }
        catch (IOException | XPathExpressionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<CandidateElement> getCandidateElementsForInputs(Element sourceElement, EventableCondition eventableCondition) {
        return this.formInputValueHelper.getCandidateElementsForInputs(this.browser, sourceElement, eventableCondition);
    }
}

