/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.forms;

import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.forms.InputValue;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FormInput {
    private long id;
    private String type = "text";
    private Identification identification;
    private Set<InputValue> inputValues = new HashSet<InputValue>();
    private Eventable eventable;
    private boolean multiple;

    public FormInput() {
    }

    public FormInput(String type, Identification identification, String value) {
        this.type = type;
        this.identification = identification;
        this.inputValues.add(new InputValue(value, value.equals("1")));
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!"".equals(type)) {
            this.type = type;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FormInput)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FormInput rhs = (FormInput)obj;
        return new EqualsBuilder().append((Object)this.identification, (Object)rhs.getIdentification()).append((Object)this.type, (Object)rhs.getType()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.identification).append((Object)this.type).toHashCode();
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static boolean containsInput(Set<FormInput> inputs, Identification identification) {
        for (FormInput input : inputs) {
            if (!input.getIdentification().equals(identification)) continue;
            return true;
        }
        return false;
    }

    public static FormInput getInput(Set<FormInput> inputs, Identification identification) {
        for (FormInput input : inputs) {
            if (!input.getIdentification().equals(identification)) continue;
            return input;
        }
        return null;
    }

    public Set<InputValue> getInputValues() {
        return this.inputValues;
    }

    public void setInputValues(Set<InputValue> inputValues) {
        this.inputValues = inputValues;
    }

    public Eventable getEventable() {
        return this.eventable;
    }

    public void setEventable(Eventable eventable) {
        this.eventable = eventable;
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public void setIdentification(Identification identification) {
        this.identification = identification;
    }
}

