/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.forms;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.eventablecondition.EventableCondition;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.configuration.InputSpecification;
import com.crawljax.core.state.Identification;
import com.crawljax.forms.FormInput;
import com.crawljax.forms.InputValue;
import com.crawljax.util.DomUtils;
import com.crawljax.util.XPathHelper;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FormInputValueHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FormInputValueHelper.class.getName());
    private ImmutableMap<String, String> formFields;
    private ImmutableListMultimap<String, String> formFieldNames;
    private ImmutableListMultimap<String, String> fieldValues;
    private boolean randomInput;
    private static final int EMPTY = 0;

    public FormInputValueHelper(InputSpecification inputSpecification, boolean randomInput) {
        this.formFieldNames = inputSpecification.getFormFieldNames();
        this.fieldValues = inputSpecification.getFormFieldValues();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.formFieldNames.entries()) {
            builder.put(entry.getValue(), entry.getKey());
        }
        this.formFields = builder.build();
        this.randomInput = randomInput;
    }

    private Element getBelongingElement(Document dom, String fieldName) {
        List<String> names = this.getNamesForInputFieldId(fieldName);
        if (names != null) {
            for (String name : names) {
                String xpath = "//*[@name='" + name + "' or @id='" + name + "']";
                try {
                    Element node = DomUtils.getElementByXpath(dom, xpath);
                    if (node == null) continue;
                    return node;
                }
                catch (XPathExpressionException e) {
                    LOGGER.debug(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private int getMaxNumberOfValues(List<String> fieldNames) {
        int maxValues = 0;
        for (String fieldName : fieldNames) {
            List<String> values = this.getValuesForName(fieldName);
            if (values == null || values.size() <= maxValues) continue;
            maxValues = values.size();
        }
        return maxValues;
    }

    public List<CandidateElement> getCandidateElementsForInputs(EmbeddedBrowser browser, Element sourceElement, EventableCondition eventableCondition) {
        Document dom;
        ArrayList<CandidateElement> candidateElements = new ArrayList<CandidateElement>();
        int maxValues = this.getMaxNumberOfValues(eventableCondition.getLinkedInputFields());
        if (maxValues == 0) {
            LOGGER.warn("No input values found for element: " + DomUtils.getElementString(sourceElement));
            return candidateElements;
        }
        try {
            dom = DomUtils.asDocument(browser.getStrippedDomWithoutIframeContent());
        }
        catch (IOException e) {
            LOGGER.error("Catched IOException while parsing dom", (Throwable)e);
            return candidateElements;
        }
        for (int curValueIndex = 0; curValueIndex < maxValues; ++curValueIndex) {
            ArrayList<FormInput> formInputsForCurrentIndex = new ArrayList<FormInput>();
            for (String fieldName : eventableCondition.getLinkedInputFields()) {
                Element element = this.getBelongingElement(dom, fieldName);
                if (element != null) {
                    FormInput formInput = this.getFormInputWithIndexValue(browser, element, curValueIndex);
                    formInputsForCurrentIndex.add(formInput);
                    continue;
                }
                LOGGER.warn("Could not find input element for: " + fieldName);
            }
            String id = eventableCondition.getId() + "_" + curValueIndex;
            sourceElement.setAttribute("atusa", id);
            Element cloneElement = (Element)sourceElement.cloneNode(false);
            cloneElement.setTextContent(DomUtils.getTextValue(sourceElement));
            CandidateElement candidateElement = new CandidateElement(cloneElement, XPathHelper.getXPathExpression(sourceElement), formInputsForCurrentIndex);
            candidateElements.add(candidateElement);
        }
        return candidateElements;
    }

    public Node getBelongingNode(FormInput input, Document dom) throws XPathExpressionException {
        Element result = null;
        switch (input.getIdentification().getHow()) {
            case xpath: {
                result = DomUtils.getElementByXpath(dom, input.getIdentification().getValue());
                break;
            }
            case id: 
            case name: {
                String xpath = "";
                String element = "";
                element = input.getType().equalsIgnoreCase("select") || input.getType().equalsIgnoreCase("textarea") ? input.getType().toUpperCase() : "INPUT";
                xpath = "//" + element + "[@name='" + input.getIdentification().getValue() + "' or @id='" + input.getIdentification().getValue() + "']";
                result = DomUtils.getElementByXpath(dom, xpath);
                break;
            }
            default: {
                LOGGER.info("Identification " + input.getIdentification() + " not supported yet for form inputs.");
            }
        }
        return result;
    }

    private Identification getIdentification(Node element) throws Exception {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes.getNamedItem("id") != null) {
            return new Identification(Identification.How.id, attributes.getNamedItem("id").getNodeValue());
        }
        if (attributes.getNamedItem("name") != null) {
            return new Identification(Identification.How.name, attributes.getNamedItem("name").getNodeValue());
        }
        String xpathExpr = XPathHelper.getXPathExpression(element);
        if (xpathExpr != null && !xpathExpr.equals("")) {
            return new Identification(Identification.How.xpath, xpathExpr);
        }
        return null;
    }

    public FormInput getFormInputWithDefaultValue(EmbeddedBrowser browser, Node element) {
        return this.getFormInput(browser, element, 0);
    }

    public FormInput getFormInputWithIndexValue(EmbeddedBrowser browser, Node element, int indexValue) {
        return this.getFormInput(browser, element, indexValue);
    }

    private FormInput getFormInput(EmbeddedBrowser browser, Node element, int indexValue) {
        Identification identification;
        try {
            identification = this.getIdentification(element);
            if (identification == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        String id = this.fieldMatches(identification.getValue());
        FormInput input = new FormInput();
        input.setType(this.getElementType(element));
        input.setIdentification(identification);
        HashSet<InputValue> values = new HashSet<InputValue>();
        if (id != null && this.fieldValues.containsKey((Object)id)) {
            String value = indexValue == 0 || this.fieldValues.get((Object)id).size() == 1 || indexValue + 1 > this.fieldValues.get((Object)id).size() ? (String)this.fieldValues.get((Object)id).get(0) : (indexValue > 0 ? (String)this.fieldValues.get((Object)id).get(indexValue) : (String)this.fieldValues.get((Object)id).get(new Random().nextInt(this.fieldValues.get((Object)id).size() - 1)));
            if (input.getType().equals("checkbox") || input.getType().equals("radio")) {
                values.add(new InputValue(value, value.equals("1")));
            } else {
                values.add(new InputValue(value, true));
            }
            input.setInputValues(values);
        } else if (this.randomInput) {
            return browser.getInputWithRandomValue(input);
        }
        return input;
    }

    private String fieldMatches(String fieldName) {
        for (String field : this.formFields.keySet()) {
            Pattern p = Pattern.compile(field, 2);
            Matcher m = p.matcher(fieldName);
            if (!m.matches()) continue;
            return (String)this.formFields.get((Object)field);
        }
        return null;
    }

    private List<String> getValuesForName(String inputFieldId) {
        if (!this.fieldValues.containsKey((Object)inputFieldId)) {
            return null;
        }
        return this.fieldValues.get((Object)inputFieldId);
    }

    private List<String> getNamesForInputFieldId(String inputFieldId) {
        if (!this.formFieldNames.containsKey((Object)inputFieldId)) {
            return null;
        }
        return this.formFieldNames.get((Object)inputFieldId);
    }

    private String getElementType(Node node) {
        if (node.getAttributes().getNamedItem("type") != null) {
            return node.getAttributes().getNamedItem("type").getNodeValue().toLowerCase();
        }
        if (node.getNodeName().equalsIgnoreCase("input")) {
            return "text";
        }
        return node.getNodeName().toLowerCase();
    }
}

