/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.oraclecomparator;

import com.crawljax.condition.Condition;
import com.crawljax.oraclecomparator.Comparator;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class OracleComparator {
    private final List<Condition> preConditions = new ArrayList<Condition>();
    private final String id;
    private final Comparator oracle;

    public OracleComparator(String id, Comparator oracle) {
        this.id = id;
        this.oracle = oracle;
    }

    public OracleComparator(String id, Comparator oracle, List<Condition> preConditions) {
        this(id, oracle);
        this.preConditions.addAll(preConditions);
    }

    public OracleComparator(String id, Comparator oracle, Condition ... preConditions) {
        this(id, oracle);
        for (Condition condition : preConditions) {
            this.preConditions.add(condition);
        }
    }

    public String getId() {
        return this.id;
    }

    public Comparator getOracle() {
        return this.oracle;
    }

    public List<Condition> getPreConditions() {
        return this.preConditions;
    }
}

