/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.oraclecomparator;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.Condition;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.oraclecomparator.Comparator;
import com.crawljax.oraclecomparator.OracleComparator;
import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StateComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)StateComparator.class.getName());
    public static final boolean COMPARE_IGNORE_CASE = true;
    private final ImmutableList<OracleComparator> oracleComparator;

    @Inject
    public StateComparator(CrawlRules config) {
        this.oracleComparator = config.getOracleComparators();
    }

    public String getStrippedDom(EmbeddedBrowser browser) {
        String newDom = browser.getStrippedDom();
        for (OracleComparator oraclePreCondition : this.oracleComparator) {
            if (!this.allPreConditionsSucceed(oraclePreCondition, browser)) continue;
            Comparator oracle = oraclePreCondition.getOracle();
            LOGGER.debug("Using {} : {}", (Object)oracle.getClass().getSimpleName(), (Object)oraclePreCondition.getId());
            boolean equivalent = oracle.isEquivalent("", newDom);
            newDom = oracle.normalize(newDom);
            if (!equivalent) continue;
            return newDom;
        }
        return newDom;
    }

    private boolean allPreConditionsSucceed(OracleComparator oraclePreCondition, EmbeddedBrowser browser) {
        for (Condition preCondition : oraclePreCondition.getPreConditions()) {
            LOGGER.debug("Check precondition: " + preCondition.toString());
            if (preCondition.check(browser)) continue;
            return false;
        }
        return true;
    }
}

