/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.oraclecomparator.comparators;

import com.crawljax.oraclecomparator.AbstractComparator;
import java.util.ArrayList;
import java.util.List;

public class AttributeComparator
extends AbstractComparator {
    private final List<String> ignoreAttributes = new ArrayList<String>();

    public AttributeComparator(String ... attributes) {
        for (String attribute : attributes) {
            this.ignoreAttributes.add(attribute);
        }
    }

    @Override
    public String normalize(String dom) {
        String strippedDom = dom;
        for (String attribute : this.ignoreAttributes) {
            String regExp = "\\s" + attribute + "=\"[^\"]*\"";
            strippedDom = dom.replaceAll(regExp, "");
        }
        return strippedDom;
    }
}

