/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.oraclecomparator.comparators;

import com.crawljax.oraclecomparator.AbstractComparator;
import org.apache.commons.lang3.StringUtils;

public class EditDistanceComparator
extends AbstractComparator {
    private double treshold = 1.0;

    public EditDistanceComparator() {
    }

    public EditDistanceComparator(double treshold) {
        this.treshold = treshold;
    }

    @Override
    public boolean isEquivalent(String oldDom, String newDom) {
        return this.isClone(oldDom, newDom, this.getTreshold());
    }

    public double getTreshold() {
        return this.treshold;
    }

    public void setTreshold(double treshold) {
        this.treshold = treshold;
    }

    boolean isClone(String str1, String str2, double thresholdCoef) {
        if (thresholdCoef < 0.0 || thresholdCoef > 1.0) {
            throw new IllegalArgumentException("Threshold Coefficient must be between 0.0 and 1.0!");
        }
        return (double)StringUtils.getLevenshteinDistance((CharSequence)str1, (CharSequence)str2) <= this.getThreshold(str1, str2, thresholdCoef);
    }

    double getThreshold(String x, String y, double p) {
        return (double)(2 * Math.max(x.length(), y.length())) * (1.0 - p);
    }
}

