/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.oraclecomparator.comparators;

import com.crawljax.oraclecomparator.AbstractComparator;
import com.crawljax.util.DomUtils;
import com.crawljax.util.XPathHelper;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleComparator
extends AbstractComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)StyleComparator.class.getName());
    private static final String[] IGNORE_ATTRIBUTES = new String[]{"align", "bgcolor", "height", "valign", "width", "type", "dir"};
    private static final String[] IGNORE_TAGS = new String[]{"em", "strong", "dfn", "code", "samp", "kdb", "var", "cite", "tt", "b", "i", "u", "big", "small", "pre", "font"};
    private static final String[] ALLOW_STYLE_TYPES = new String[]{"display", "visibility"};

    @Override
    public String normalize(String dom) {
        try {
            return DomUtils.getDocumentToString(this.stripDom(DomUtils.asDocument(dom)));
        }
        catch (IOException e) {
            LOGGER.warn("Could not complete dom comparison", (Throwable)e);
            return dom;
        }
    }

    private Document stripDom(Document dom) {
        Document strippedDom = this.stripElements(dom);
        strippedDom = this.stripAttributes(strippedDom);
        strippedDom = this.stripStyleAttributes(strippedDom);
        return strippedDom;
    }

    private Document stripStyleAttributes(Document dom) {
        try {
            NodeList nl = XPathHelper.evaluateXpathExpression(dom, "//*[@style]/@style");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node attribute = nl.item(i);
                if (attribute == null) continue;
                attribute.setNodeValue(this.stripStyleProperties(attribute.getNodeValue()));
                if (!attribute.getNodeValue().equals("")) continue;
                ((Attr)attribute).getOwnerElement().removeAttribute(attribute.getNodeName());
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Error with StyleOracle: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (DOMException e) {
            LOGGER.warn("Error with StyleOracle: {}", (Object)e.getMessage(), (Object)e);
        }
        return dom;
    }

    private Document stripElements(Document dom) {
        for (String tag : IGNORE_TAGS) {
            try {
                NodeList nl = XPathHelper.evaluateXpathExpression(dom, "//" + tag.toUpperCase());
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node removeNode = nl.item(i);
                    Node parent = removeNode.getParentNode();
                    Node nextSibling = removeNode.getNextSibling();
                    NodeList children = removeNode.getChildNodes();
                    if (children != null && children.getLength() > 0) {
                        if (nextSibling == null) {
                            parent.appendChild(children.item(0));
                        } else {
                            parent.insertBefore(children.item(0), nextSibling);
                        }
                    }
                    parent.removeChild(removeNode);
                }
            }
            catch (XPathExpressionException e) {
                LOGGER.warn("Error with StyleOracle: " + e.getMessage());
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (DOMException e) {
                LOGGER.warn("Error with StyleOracle: " + e.getMessage());
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return dom;
    }

    private Document stripAttributes(Document dom) {
        for (String attributeName : IGNORE_ATTRIBUTES) {
            String attribute = attributeName.toLowerCase();
            try {
                NodeList nl = XPathHelper.evaluateXpathExpression(dom, "//*[@" + attribute + "]");
                for (int i = 0; i < nl.getLength(); ++i) {
                    NamedNodeMap attributes = nl.item(i).getAttributes();
                    attributes.removeNamedItem(attribute);
                }
            }
            catch (XPathExpressionException e) {
                LOGGER.warn("Error with StyleOracle: " + e.getMessage());
            }
            catch (DOMException e) {
                LOGGER.warn("Error with StyleOracle: " + e.getMessage());
            }
        }
        return dom;
    }

    private String stripStyleProperties(String styleAttribute) {
        String[] styleProperties = styleAttribute.split(";");
        String badWayOfDoingThis = "";
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < styleProperties.length; ++i) {
            String[] styleProperty = styleProperties[i].split(":");
            if (styleProperty.length != 2) continue;
            for (int j = 0; j < ALLOW_STYLE_TYPES.length; ++j) {
                if (!styleProperty[0].trim().equalsIgnoreCase(ALLOW_STYLE_TYPES[j])) continue;
                badWayOfDoingThis = badWayOfDoingThis + styleProperty[0].trim() + ": " + styleProperty[1].trim() + ";";
                buffer.append(styleProperty[0].trim());
                buffer.append(": ");
                buffer.append(styleProperty[1].trim());
                buffer.append(";");
            }
        }
        return badWayOfDoingThis;
    }
}

