/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.oraclecomparator.comparators;

import com.crawljax.oraclecomparator.AbstractComparator;
import com.crawljax.util.DomUtils;
import com.crawljax.util.XPathHelper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathExpressionComparator
extends AbstractComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)XPathExpressionComparator.class.getName());
    private final ImmutableList<String> expressions;

    public XPathExpressionComparator(Collection<String> expressions) {
        this.expressions = ImmutableList.copyOf(expressions);
    }

    public XPathExpressionComparator(String ... expressions) {
        this.expressions = ImmutableList.copyOf((Object[])expressions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String normalize(String dom) {
        String domRet;
        String curExpression = "";
        Document doc = null;
        try {
            doc = DomUtils.asDocument(dom);
            Iterator i$ = this.expressions.iterator();
            while (i$.hasNext()) {
                String expression;
                curExpression = expression = (String)i$.next();
                NodeList nodeList = XPathHelper.evaluateXpathExpression(doc, expression);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() == 2) {
                        ((Attr)node).getOwnerElement().removeAttribute(node.getNodeName());
                        continue;
                    }
                    if (node.getNodeType() != 1) continue;
                    Node parent = node.getParentNode();
                    parent.removeChild(node);
                }
            }
        }
        catch (IOException | XPathExpressionException | DOMException e) {
            LOGGER.error("Exception with stripping XPath expression: " + curExpression, (Throwable)e);
        }
        finally {
            domRet = doc != null ? DomUtils.getDocumentToString(doc) : "";
        }
        return domRet;
    }
}

