/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import com.crawljax.core.CrawljaxException;
import com.crawljax.util.DomDifferenceListener;
import com.crawljax.util.HtmlNamespace;
import com.crawljax.util.XPathHelper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.cyberneko.html.parsers.DOMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DomUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DomUtils.class.getName());
    static final int BASE_LENGTH = 3;
    private static final int TEXT_CUTOFF = 50;

    public static Document asDocument(String html) throws IOException {
        DOMParser domParser = new DOMParser();
        try {
            domParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
            domParser.setFeature("http://xml.org/sax/features/namespaces", false);
            domParser.parse(new InputSource(new StringReader(html)));
        }
        catch (SAXException e) {
            throw new IOException("Error while reading HTML: " + html, e);
        }
        return domParser.getDocument();
    }

    public static Document getDocumentNoBalance(String html) throws SAXException, IOException {
        DOMParser domParser = new DOMParser();
        domParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
        domParser.setFeature("http://cyberneko.org/html/features/balance-tags", false);
        domParser.parse(new InputSource(new StringReader(html)));
        return domParser.getDocument();
    }

    public static String getAllElementAttributes(Element element) {
        return DomUtils.getElementAttributes(element, (ImmutableSet<String>)ImmutableSet.of());
    }

    public static String getElementAttributes(Element element, ImmutableSet<String> exclude) {
        NamedNodeMap attributes;
        StringBuilder buffer = new StringBuilder();
        if (element != null && (attributes = element.getAttributes()) != null) {
            DomUtils.addAttributesToString(exclude, buffer, attributes);
        }
        return buffer.toString().trim();
    }

    private static void addAttributesToString(ImmutableSet<String> exclude, StringBuilder buffer, NamedNodeMap attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (exclude.contains((Object)attr.getNodeName())) continue;
            buffer.append(attr.getNodeName()).append('=');
            buffer.append(attr.getNodeValue()).append(' ');
        }
    }

    public static String getElementString(Element element) {
        String text = DomUtils.removeNewLines(DomUtils.getTextValue(element)).trim();
        StringBuilder info = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)text)) {
            info.append("\"").append(text).append("\" ");
        }
        if (element != null) {
            if (element.hasAttribute("id")) {
                info.append("ID: ").append(element.getAttribute("id")).append(" ");
            }
            info.append(DomUtils.getAllElementAttributes(element)).append(" ");
        }
        return info.toString();
    }

    public static Element getElementByXpath(Document dom, String xpath) throws XPathExpressionException {
        XPath xp = XPathFactory.newInstance().newXPath();
        xp.setNamespaceContext(new HtmlNamespace());
        return (Element)xp.evaluate(xpath, dom, XPathConstants.NODE);
    }

    public static Document removeScriptTags(Document dom) {
        return DomUtils.removeTags(dom, "SCRIPT");
    }

    public static Document removeTags(Document dom, String tagName) {
        try {
            NodeList list = XPathHelper.evaluateXpathExpression(dom, "//" + tagName.toUpperCase());
            while (list.getLength() > 0) {
                Node sc = list.item(0);
                if (sc != null) {
                    sc.getParentNode().removeChild(sc);
                }
                list = XPathHelper.evaluateXpathExpression(dom, "//" + tagName.toUpperCase());
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Error while removing tag " + tagName, (Throwable)e);
        }
        return dom;
    }

    public static String getDocumentToString(Document dom) {
        try {
            DOMSource source = new DOMSource(dom);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "html");
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerException e) {
            throw new CrawljaxException("Could not tranform the DOM", e);
        }
    }

    public static byte[] getDocumentToByteArray(Document dom) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "html");
            transformer.setOutputProperty("doctype-public", "-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
            DOMSource source = new DOMSource(dom);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            return out.toByteArray();
        }
        catch (TransformerException e) {
            LOGGER.error("Error while converting the document to a byte array", (Throwable)e);
            return null;
        }
    }

    public static String getTextValue(Element element) {
        String ret = "";
        String textContent = element.getTextContent();
        if (textContent != null && !textContent.equals("")) {
            ret = textContent;
        } else if (element.hasAttribute("title")) {
            ret = element.getAttribute("title");
        } else if (element.hasAttribute("alt")) {
            ret = element.getAttribute("alt");
        }
        if (ret.length() > 50) {
            return ret.substring(0, 50);
        }
        return ret;
    }

    public static List<Difference> getDifferences(String controlDom, String testDom) {
        return DomUtils.getDifferences(controlDom, testDom, Lists.newArrayList());
    }

    public static List<Difference> getDifferences(String controlDom, String testDom, List<String> ignoreAttributes) {
        try {
            Diff d = new Diff(DomUtils.asDocument(controlDom), DomUtils.asDocument(testDom));
            DetailedDiff dd = new DetailedDiff(d);
            dd.overrideDifferenceListener((DifferenceListener)new DomDifferenceListener(ignoreAttributes));
            return dd.getAllDifferences();
        }
        catch (IOException e) {
            LOGGER.error("Error with getDifferences: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String removeNewLines(String html) {
        return html.replaceAll("[\\t\\n\\x0B\\f\\r]", "");
    }

    public static String replaceString(String string, String regex, String replace) {
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(string);
        String replaced = m.replaceAll(replace);
        p = Pattern.compile("  ", 32);
        m = p.matcher(replaced);
        return m.replaceAll(" ");
    }

    public static String addFolderSlashIfNeeded(String folderName) {
        if (!"".equals(folderName) && !folderName.endsWith("/")) {
            return folderName + "/";
        }
        return folderName;
    }

    private static String getFileNameInPath(String path) {
        String fname = path.indexOf(47) != -1 ? path.substring(path.lastIndexOf(47) + 1) : path;
        return fname;
    }

    public static String getTemplateAsString(String fname) throws IOException {
        String line;
        String fnameJar = DomUtils.getFileNameInPath(fname);
        InputStream inStream = DomUtils.class.getResourceAsStream("/" + fnameJar);
        if (inStream == null) {
            File f = new File(fname);
            if (f.exists()) {
                inStream = new FileInputStream(f);
            } else {
                throw new IOException("Cannot find " + fname + " or " + fnameJar);
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inStream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line + "\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static String getJSGetElement(String xpath) {
        String js = "function ATUSA_getElementInNodes(nodes, tagName, number){try{var pos = 1;for(i=0; i<nodes.length; i++){if(nodes[i]!=null && nodes[i].tagName!=null && nodes[i].tagName.toLowerCase() == tagName){if(number==pos){return nodes[i];}else{pos++;}}}}catch(e){}return null;}function ATUSA_getElementByXpath(xpath){try{var elements = xpath.toLowerCase().split('/');var curNode = window.document.body;var tagName, number;for(j=0; j<elements.length; j++){if(elements[j]!=''){if(elements[j].indexOf('[')==-1){tagName = elements[j];number = 1;}else{tagName = elements[j].substring(0, elements[j].indexOf('['));number = elements[j].substring(elements[j].indexOf('[')+1, elements[j].lastIndexOf(']'));}if(tagName!='body' && tagName!='html'){curNode = ATUSA_getElementInNodes(curNode.childNodes, tagName, number);if(curNode==null){return null;}}}}}catch(e){return null;}return curNode;}try{var ATUSA_element = ATUSA_getElementByXpath('" + xpath + "');}catch(e){return null;}";
        return js;
    }

    public static String getFrameIdentification(Element frame) {
        Attr attr = frame.getAttributeNode("id");
        if (attr != null && attr.getNodeValue() != null && !attr.getNodeValue().equals("")) {
            return attr.getNodeValue();
        }
        attr = frame.getAttributeNode("name");
        if (attr != null && attr.getNodeValue() != null && !attr.getNodeValue().equals("")) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static void writeDocumentToFile(Document document, String filePathname, String method, int indent) throws TransformerException, IOException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", method);
        transformer.transform(new DOMSource(document), new StreamResult(new FileOutputStream(filePathname)));
    }

    private DomUtils() {
    }
}

