/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.state.Element;
import com.crawljax.core.state.Eventable;
import com.crawljax.util.DomUtils;
import com.crawljax.util.XPathHelper;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ElementResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementResolver.class);
    private final EmbeddedBrowser browser;
    private final Eventable eventable;

    public ElementResolver(Eventable eventable, EmbeddedBrowser browser) {
        this.browser = browser;
        this.eventable = eventable;
    }

    public String resolve() {
        return this.resolve(false);
    }

    public String resolve(boolean logging) {
        Document dom = null;
        try {
            dom = DomUtils.asDocument(this.browser.getStrippedDom());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
        try {
            String xpathEventable = this.eventable.getIdentification().getValue();
            org.w3c.dom.Element nodeSameXpath = DomUtils.getElementByXpath(dom, xpathEventable);
            if (nodeSameXpath != null) {
                Element elementSameXpath = new Element(nodeSameXpath);
                if (logging) {
                    LOGGER.info("Try element with same xpath expression");
                }
                if (this.equivalent(elementSameXpath, logging)) {
                    return xpathEventable;
                }
            }
            if (logging) {
                LOGGER.info("Search other candidate elements");
            }
            NodeList candidateElements = XPathHelper.evaluateXpathExpression(dom, "//" + this.eventable.getElement().getTag().toUpperCase());
            if (logging) {
                LOGGER.info("Candidates: " + candidateElements.getLength());
            }
            for (int i = 0; i < candidateElements.getLength(); ++i) {
                Element candidateElement = new Element(candidateElements.item(i));
                if (!this.equivalent(candidateElement, logging)) continue;
                return XPathHelper.getXPathExpression(candidateElements.item(i));
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (logging) {
            LOGGER.info("No equivalent element found");
        }
        return null;
    }

    public boolean equivalent(Element otherElement, boolean logging) {
        if (this.eventable.getElement().equals(otherElement)) {
            if (logging) {
                LOGGER.info("Element equal");
            }
            return true;
        }
        if (this.eventable.getElement().equalAttributes(otherElement)) {
            if (logging) {
                LOGGER.info("Element attributes equal");
            }
            return true;
        }
        if (this.eventable.getElement().equalId(otherElement)) {
            if (logging) {
                LOGGER.info("Element ID equal");
            }
            return true;
        }
        if (!this.eventable.getElement().getText().equals("") && this.eventable.getElement().equalText(otherElement)) {
            if (logging) {
                LOGGER.info("Element text equal");
            }
            return true;
        }
        return false;
    }
}

