/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UrlUtils.class);

    public static URL extractNewUrl(String currentUrl, String href) throws MalformedURLException {
        if (href == null || UrlUtils.isJavascript(href) || href.startsWith("mailto:")) {
            throw new MalformedURLException(href + " is not a HTTP url");
        }
        if (href.contains("://")) {
            return new URL(href);
        }
        return new URL(new URL(currentUrl), href);
    }

    private static boolean isJavascript(String href) {
        return href.startsWith("javascript:");
    }

    static String getBasePath(URL url) {
        String file = url.getFile().replaceAll("\\*", "");
        try {
            return url.getPath().replaceAll(file, "");
        }
        catch (PatternSyntaxException pe) {
            LOG.error(pe.getMessage());
            return "";
        }
    }

    public static String getBaseUrl(String url) {
        String head = url.substring(0, url.indexOf(58));
        String subLoc = url.substring(head.length() + 3);
        return head + "://" + subLoc.substring(0, subLoc.indexOf(47));
    }

    public static String getVarFromQueryString(String varName, String haystack) {
        String[] vars;
        if (haystack == null || haystack.length() == 0) {
            return null;
        }
        String modifiedHaystack = haystack;
        if (modifiedHaystack.charAt(0) == '?') {
            modifiedHaystack = modifiedHaystack.substring(1);
        }
        for (String var : vars = modifiedHaystack.split("&")) {
            String[] tuple = var.split("=");
            if (tuple.length != 2 || !tuple[0].equals(varName)) continue;
            return tuple[1];
        }
        return null;
    }

    public static boolean isSameDomain(String currentUrl, URL url) {
        try {
            String current = URI.create(currentUrl).getHost().toLowerCase();
            String original = url.toURI().getHost().toLowerCase();
            return current.endsWith(original);
        }
        catch (URISyntaxException e) {
            LOG.warn("Could not parse URI {}", (Object)currentUrl);
            return false;
        }
    }

    private UrlUtils() {
    }
}

