/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import com.crawljax.util.DomUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathHelper {
    private static final Pattern TAG_PATTERN = Pattern.compile("(?<=[/|::])[a-zA-z]+(?=([/|\\[]|$))");
    private static final Pattern ID_PATTERN = Pattern.compile("(@[a-zA-Z]+)");
    private static final String FULL_XPATH_CACHE = "FULL_XPATH_CACHE";
    private static final int MAX_SEARCH_LOOPS = 10000;

    public static String getXPathExpression(Node node) {
        Object xpathCache = node.getUserData(FULL_XPATH_CACHE);
        if (xpathCache != null) {
            return xpathCache.toString();
        }
        Node parent = node.getParentNode();
        if (parent == null || parent.getNodeName().contains("#document")) {
            String xPath = "/" + node.getNodeName() + "[1]";
            node.setUserData(FULL_XPATH_CACHE, xPath, null);
            return xPath;
        }
        StringBuffer buffer = new StringBuffer();
        if (parent != node) {
            buffer.append(XPathHelper.getXPathExpression(parent));
            buffer.append("/");
        }
        buffer.append(node.getNodeName());
        List<Node> mySiblings = XPathHelper.getSiblings(parent, node);
        for (int i = 0; i < mySiblings.size(); ++i) {
            Node el = mySiblings.get(i);
            if (!el.equals(node)) continue;
            buffer.append('[').append(Integer.toString(i + 1)).append(']');
            break;
        }
        String xPath = buffer.toString();
        node.setUserData(FULL_XPATH_CACHE, xPath, null);
        return xPath;
    }

    public static List<Node> getSiblings(Node parent, Node element) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node el = list.item(i);
            if (!el.getNodeName().equals(element.getNodeName())) continue;
            result.add(el);
        }
        return result;
    }

    public static NodeList evaluateXpathExpression(String domStr, String xpathExpr) throws XPathExpressionException, IOException {
        Document dom = DomUtils.asDocument(domStr);
        return XPathHelper.evaluateXpathExpression(dom, xpathExpr);
    }

    public static NodeList evaluateXpathExpression(Document dom, String xpathExpr) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(xpathExpr);
        Object result = expr.evaluate(dom, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        return nodes;
    }

    public static ImmutableList<String> getXpathForXPathExpressions(Document dom, String xpathExpression) throws XPathExpressionException {
        NodeList nodeList = XPathHelper.evaluateXpathExpression(dom, xpathExpression);
        ImmutableList.Builder result = ImmutableList.builder();
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                result.add((Object)XPathHelper.getXPathExpression(n));
            }
        }
        return result.build();
    }

    public static String formatXPath(String xpath) {
        String formatted = XPathHelper.capitalizeTagNames(xpath);
        formatted = XPathHelper.lowerCaseAttributes(formatted);
        return formatted;
    }

    private static String lowerCaseAttributes(String formatted) {
        Matcher m = ID_PATTERN.matcher(formatted);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String text = m.group();
            m.appendReplacement(sb, Matcher.quoteReplacement(text.toLowerCase()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String capitalizeTagNames(String xpath) {
        Matcher m = TAG_PATTERN.matcher(xpath);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String text = m.group();
            m.appendReplacement(sb, Matcher.quoteReplacement(text.toUpperCase()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String getLastElementXPath(String xpath) {
        String[] elements = xpath.split("/");
        for (int i = elements.length - 1; i >= 0; --i) {
            if (elements[i].equals("") || elements[i].indexOf("()") != -1 || elements[i].startsWith("@")) continue;
            return XPathHelper.stripEndSquareBrackets(elements[i]);
        }
        return "";
    }

    private static String stripEndSquareBrackets(String string) {
        if (string.contains("[")) {
            return string.substring(0, string.indexOf(91));
        }
        return string;
    }

    public static int getXPathLocation(String dom, String xpath) {
        String dom_lower = dom.toLowerCase();
        String xpath_lower = xpath.toLowerCase();
        String[] elements = xpath_lower.split("/");
        int pos = 0;
        for (String element : elements) {
            int number;
            if (element.isEmpty() || element.startsWith("@") || element.contains("()")) continue;
            if (element.contains("[")) {
                try {
                    number = Integer.parseInt(element.substring(element.indexOf("[") + 1, element.indexOf("]")));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            } else {
                number = 1;
            }
            for (int i = 0; i < number; ++i) {
                int temp = dom_lower.indexOf("<" + XPathHelper.stripEndSquareBrackets(element), pos);
                if (temp <= -1) continue;
                pos = temp + 1;
                if (number <= 1 || i >= number - 1) continue;
                pos = XPathHelper.getCloseElementLocation(dom_lower, pos, XPathHelper.stripEndSquareBrackets(element));
            }
        }
        return pos - 1;
    }

    public static int getCloseElementLocation(String dom, int pos, String element) {
        String[] elements = new String[]{"LINK", "META", "INPUT", "BR"};
        List<String> singleElements = Arrays.asList(elements);
        if (singleElements.contains(element.toUpperCase())) {
            return dom.indexOf(62, pos) + 1;
        }
        int openElements = 1;
        int position = pos;
        String dom_lower = dom.toLowerCase();
        String element_lower = element.toLowerCase();
        String openElement = "<" + element_lower;
        String closeElement = "</" + element_lower;
        for (int i = 0; i < 10000; ++i) {
            if (dom_lower.indexOf(openElement, position) == -1 && dom_lower.indexOf(closeElement, position) == -1) {
                return -1;
            }
            if (dom_lower.indexOf(openElement, position) < dom_lower.indexOf(closeElement, position) && dom_lower.indexOf(openElement, position) != -1) {
                ++openElements;
                position = dom_lower.indexOf(openElement, position) + 1;
            } else {
                --openElements;
                position = dom_lower.indexOf(closeElement, position) + 1;
            }
            if (openElements == 0) break;
        }
        return position - 1;
    }

    public static int getCloseElementLocation(String dom, String xpath) {
        return XPathHelper.getCloseElementLocation(dom, XPathHelper.getXPathLocation(dom, xpath) + 1, XPathHelper.getLastElementXPath(xpath));
    }

    public static String stripXPathToElement(String xpath) {
        String xpathStripped = xpath;
        if (!Strings.isNullOrEmpty((String)xpathStripped)) {
            if (xpathStripped.toLowerCase().contains("/text()")) {
                xpathStripped = xpathStripped.substring(0, xpathStripped.toLowerCase().indexOf("/text()"));
            }
            if (xpathStripped.toLowerCase().contains("/comment()")) {
                xpathStripped = xpathStripped.substring(0, xpathStripped.toLowerCase().indexOf("/comment()"));
            }
            if (xpathStripped.contains("@")) {
                xpathStripped = xpathStripped.substring(0, xpathStripped.indexOf("@") - 1);
            }
        }
        return xpathStripped;
    }

    private XPathHelper() {
    }
}

