/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font;

import com.day.image.internal.font.FontFileProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontFileProviderImpl
implements FontFileProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DIGEST = "SHA-1";
    private static final String FILENAME_PREFIX = FontFileProviderImpl.class.getSimpleName() + "_";
    private static final String FILE_EXT = ".font";
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private BundleContext bundleContext;
    private AtomicInteger tmpFileCounter = new AtomicInteger();

    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        File f = ctx.getBundleContext().getDataFile("FOO");
        this.deleteMatchingFiles(f.getParentFile(), FILENAME_PREFIX);
    }

    void deleteMatchingFiles(File folder, String namePrefix) {
        if (!folder.isDirectory()) {
            this.log.debug("deleteMatchingFiles: {} is not a folder", (Object)folder.getAbsolutePath());
            return;
        }
        String[] names = folder.list();
        int deleted = 0;
        if (names != null) {
            for (String name : names) {
                if (!name.startsWith(namePrefix)) continue;
                File f = new File(folder, name);
                f.delete();
                if (f.exists()) {
                    this.log.info("Failed to delete font file {}, might be in use. Will try again next time", (Object)f.getAbsolutePath());
                    continue;
                }
                this.log.debug("Deleted possibly unused font file {}", (Object)f.getAbsolutePath());
                ++deleted;
            }
        }
        if (deleted > 0) {
            this.log.info("{} possibly unused font files deleted from {}", (Object)deleted, (Object)folder.getAbsolutePath());
        } else {
            this.log.info("No unused font files found under {}", (Object)folder.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileForStream(InputStream is) throws IOException {
        File result = null;
        File tmp = this.bundleContext.getDataFile("TMP_" + this.tmpFileCounter.incrementAndGet() + "_" + System.currentTimeMillis() + ".tmp");
        try {
            MessageDigest digest = null;
            try {
                digest = MessageDigest.getInstance(DIGEST);
            }
            catch (NoSuchAlgorithmException nse) {
                throw new IOException("NoSuchAlgorithmException with digest=SHA-1", nse);
            }
            DigestOutputStream os = new DigestOutputStream(new FileOutputStream(tmp), digest);
            byte[] buffer = new byte[8192];
            int n = 0;
            while ((n = is.read(buffer, 0, buffer.length)) > 0) {
                ((OutputStream)os).write(buffer, 0, n);
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            result = this.bundleContext.getDataFile(this.digestToFilename(digest.digest()));
            boolean fileExists = false;
            FontFileProviderImpl fontFileProviderImpl = this;
            synchronized (fontFileProviderImpl) {
                fileExists = result.canRead();
                if (!fileExists) {
                    tmp.renameTo(result);
                    if (!result.canRead()) {
                        throw new IOException("Error renaming " + tmp.getAbsolutePath() + " to " + result.getAbsolutePath());
                    }
                    tmp = null;
                }
            }
            if (fileExists) {
                this.log.debug("{} font file already provided, using it as is", (Object)result.getAbsolutePath());
            } else {
                result.deleteOnExit();
                this.log.info("Font file created for new content (will be deleted on exit): {}", (Object)result.getAbsolutePath());
            }
        }
        finally {
            if (tmp != null) {
                this.log.debug("Deleting unused temp file {}", (Object)tmp.getAbsolutePath());
                tmp.delete();
                if (tmp.exists()) {
                    this.log.warn("Failed to delete temporary file {}", (Object)tmp.getAbsolutePath());
                }
            }
            is.close();
        }
        return result;
    }

    private String digestToFilename(byte[] digest) {
        StringBuilder sb = new StringBuilder(FILENAME_PREFIX);
        for (byte b : digest) {
            sb.append(HEX[b >> 4 & 0xF]);
            sb.append(HEX[b & 0xF]);
        }
        sb.append(FILE_EXT);
        return sb.toString();
    }
}

