/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font;

import com.day.image.font.AbstractFont;
import com.day.image.font.FontListEntry;
import com.day.image.internal.font.FontHelper;
import java.io.PrintWriter;
import java.util.List;
import org.apache.felix.webconsole.ConfigurationPrinter;

public class FontListPanel
implements ConfigurationPrinter {
    private static final String TITLE = "GFX supported Fonts";

    public String getTitle() {
        return TITLE;
    }

    public void printConfiguration(PrintWriter pw) {
        String[] fontPath;
        List<FontListEntry> fonts = FontHelper.getInstance().getFontList();
        for (FontListEntry fontListEntry : fonts) {
            pw.print(fontListEntry.getFacename());
            pw.print(", Style:");
            pw.print(AbstractFont.styleToDescription(fontListEntry.getStyle()));
            if (fontListEntry.getSize() == 0) {
                pw.print(", Scalable TrueType Font");
            } else {
                pw.print(", Size:");
                pw.print(fontListEntry.getSize());
            }
            pw.print(", Provider: ");
            pw.print(fontListEntry.getFontProvider());
            pw.println();
        }
        pw.println();
        pw.println("*** GFX Font Path:");
        for (String fontPathEntry : fontPath = FontHelper.getInstance().getFontPath()) {
            pw.println(fontPathEntry);
        }
    }
}

