/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal;

import com.day.image.internal.GlobPattern;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontPath {
    private final GlobPattern[] patterns;
    private final ResourceResolver resolver;
    private String[] currentPath;

    public FontPath(ResourceResolver resolver, String[] patternStrings) {
        this.resolver = resolver;
        this.patterns = new GlobPattern[patternStrings.length];
        for (int i = 0; i < patternStrings.length; ++i) {
            this.patterns[i] = new GlobPattern(patternStrings[i], true);
        }
        this.currentPath = null;
    }

    public String[] getCurrentPath() {
        if (this.currentPath == null) {
            this.currentPath = this.scanPath();
        }
        return this.currentPath;
    }

    public boolean matches(String path) {
        for (GlobPattern pattern : this.patterns) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }

    private String[] scanPath() {
        ArrayList<String> list = new ArrayList<String>();
        for (GlobPattern pattern : this.patterns) {
            Resource start = this.getStartResource(pattern);
            if (start == null) continue;
            this.recurse(list, pattern, start);
        }
        return list.toArray(new String[list.size()]);
    }

    private void recurse(List<String> list, GlobPattern pattern, Resource start) {
        if (pattern.matches(start.getPath())) {
            list.add(start.getPath());
        } else {
            Iterator children = ResourceUtil.listChildren((Resource)start);
            while (children.hasNext()) {
                this.recurse(list, pattern, (Resource)children.next());
            }
        }
    }

    private Resource getStartResource(GlobPattern pattern) {
        String wcp = "*?[]";
        String ps = pattern.toString();
        int slash = -1;
        for (int i = 0; i < ps.length(); ++i) {
            char c = ps.charAt(i);
            if (c == '/') {
                slash = i;
                continue;
            }
            if (wcp.indexOf(c) >= 0) break;
        }
        ps = slash >= 0 ? ps.substring(0, slash) : "/";
        return this.resolver.getResource(ps);
    }
}

