/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font;

import com.day.image.font.AbstractFont;
import com.day.image.font.FontListEntry;
import com.day.image.internal.font.FontFileProvider;
import com.day.image.internal.font.FontProvider;
import com.day.image.internal.font.PlatformFont;
import com.day.image.internal.font.fonter.FonterFontProvider;
import com.day.image.internal.font.resource.ResourceFontProvider;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontHelper {
    private static FontHelper INSTANCE;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String FONTPATH = "fontpath";
    private static final String OVERSAMPLING_FACTOR = "oversamplingFactor";
    private static final int DEFAULT_OVERSAMPLING_FACTOR = 16;
    private SlingRepository slingRepository;
    private JcrResourceResolverFactory resourceResolverFactory;
    private FontFileProvider fontFileProvider;
    private ResourceResolver resourceResolver;
    private String[] fontPath = new String[0];
    private FontProvider[] fontProviders = new FontProvider[0];

    protected void activate(ComponentContext context) {
        try {
            Session session = this.slingRepository.loginAdministrative(null);
            this.resourceResolver = this.resourceResolverFactory.getResourceResolver(session);
        }
        catch (RepositoryException re) {
            this.log.error("activate: Cannot get administrative session to access fonts !", (Throwable)re);
        }
        Dictionary props = context.getProperties();
        this.initFontPath(OsgiUtil.toStringArray(props.get(FONTPATH)));
        PlatformFont.setOversamplingFactor(OsgiUtil.toInteger(props.get(OVERSAMPLING_FACTOR), (int)16));
        INSTANCE = this;
        if (this.resourceResolver != null) {
            this.addFontProvider(new FonterFontProvider());
            this.addFontProvider(new ResourceFontProvider());
        }
    }

    protected void deactivate(ComponentContext context) {
        for (FontProvider fontProvider : this.fontProviders) {
            fontProvider.destroy();
        }
        if (INSTANCE == this) {
            INSTANCE = null;
        }
        if (this.resourceResolver != null) {
            Session session = (Session)this.resourceResolver.adaptTo(Session.class);
            if (session != null) {
                session.logout();
            }
            this.resourceResolver = null;
        }
        this.fontProviders = new FontProvider[0];
        this.fontPath = new String[0];
    }

    protected void addFontProvider(FontProvider provider) {
        provider.init(this.resourceResolver, this.getFontPath(), this.fontFileProvider);
        if (this.fontProviders.length == 0) {
            this.fontProviders = new FontProvider[]{provider};
        } else {
            FontProvider[] newfp = new FontProvider[this.fontProviders.length + 1];
            System.arraycopy(this.fontProviders, 0, newfp, 0, this.fontProviders.length);
            newfp[this.fontProviders.length] = provider;
            this.fontProviders = newfp;
        }
    }

    protected void removeFontProvider(FontProvider provider) {
        for (int i = 0; i < this.fontProviders.length; ++i) {
            if (this.fontProviders[i] != provider) continue;
            provider.destroy();
            if (this.fontProviders.length == 1) {
                this.fontProviders = new FontProvider[0];
                continue;
            }
            FontProvider[] newfp = new FontProvider[this.fontProviders.length - 1];
            if (i > 0) {
                System.arraycopy(this.fontProviders, 0, newfp, 0, i);
            }
            if (i >= this.fontProviders.length - 1) continue;
            System.arraycopy(this.fontProviders, i + 1, newfp, i, this.fontProviders.length - i);
        }
    }

    public static FontHelper getInstance() {
        if (INSTANCE == null) {
            return new FontHelper();
        }
        return INSTANCE;
    }

    String[] getFontPath() {
        return this.fontPath;
    }

    FontProvider[] getFontProviders() {
        return this.fontProviders;
    }

    public List<FontListEntry> getFontList() {
        ArrayList<FontListEntry> fontList = new ArrayList<FontListEntry>();
        for (FontProvider fontProvider : this.getFontProviders()) {
            fontList.addAll(fontProvider.getFontList());
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String platFont : env.getAvailableFontFamilyNames()) {
            fontList.add(new FontListEntry("[Java Platform]", platFont, 0, 255));
        }
        return fontList;
    }

    public AbstractFont getFont(String faceName, int size, int style) {
        AbstractFont fnt = null;
        for (int i = 0; i < this.fontProviders.length; ++i) {
            this.log.debug("Font: Asking provider {}", (Object)this.fontProviders[i]);
            fnt = this.fontProviders[i].getFont(faceName, size, style);
            if (fnt == null) continue;
            this.log.debug("Font: Using font {}", (Object)fnt);
            break;
        }
        if (fnt == null) {
            this.log.debug("Font: No provider has font, fallback to base class");
            fnt = new PlatformFont(faceName, size, style);
        }
        return fnt;
    }

    private void initFontPath(String[] fontPathConfig) {
        if (fontPathConfig != null && fontPathConfig.length > 0) {
            ArrayList<String> fontPathList = new ArrayList<String>();
            for (String fontPathEntry : fontPathConfig) {
                if (fontPathEntry == null || fontPathEntry.length() == 0) {
                    this.log.info("initFontPath: Ignoring empty font path entry");
                    continue;
                }
                if (fontPathEntry.charAt(0) != '/') {
                    this.log.info("initFontPath: Ignoring non-absolute font path entry {}", (Object)fontPathEntry);
                    continue;
                }
                fontPathList.add(fontPathEntry);
            }
            this.fontPath = fontPathList.toArray(new String[fontPathList.size()]);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Communique font settings:");
                for (String fontPathEntry : this.fontPath) {
                    this.log.debug("  Path entry {}", (Object)fontPathEntry);
                }
            }
        } else {
            this.log.debug("initFontPath: Font path not configured");
            this.fontPath = new String[0];
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resourceResolverFactory == jcrResourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindFontFileProvider(FontFileProvider fontFileProvider) {
        this.fontFileProvider = fontFileProvider;
    }

    protected void unbindFontFileProvider(FontFileProvider fontFileProvider) {
        if (this.fontFileProvider == fontFileProvider) {
            this.fontFileProvider = null;
        }
    }
}

