/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class PrettifyOutputStream
extends OutputStream {
    private static final int INDENT_CACHE_SIZE = 257;
    private static final boolean[] WHITESPACE = new boolean[256];
    private final OutputStream out;
    private final IndentType indentType;
    private final int indentLength;
    private int currentIndent = 0;
    private boolean inString = false;
    private boolean inEscape = false;
    private boolean beginObjectOrList = false;

    public PrettifyOutputStream(OutputStream out) {
        this(out, IndentType.SPACES, 2);
    }

    public PrettifyOutputStream(OutputStream out, IndentType indentType, int indentLength) {
        if (out == null) {
            throw new IllegalArgumentException("'out' must be not null");
        }
        if (indentType == null) {
            throw new IllegalArgumentException("'indentType' must be not null");
        }
        if (indentLength < 1) {
            throw new IllegalArgumentException("'indentLength' must be >= 1");
        }
        this.out = out;
        this.indentType = indentType;
        this.indentLength = indentLength;
    }

    @Override
    public final void write(byte[] bytes, int off, int len) throws IOException {
        int start = off;
        for (int i = off; i < off + len; ++i) {
            byte b = bytes[i];
            if (this.inString) {
                if (b == 34 && !this.inEscape) {
                    this.inString = false;
                    continue;
                }
                this.inEscape = !this.inEscape && b == 92;
                continue;
            }
            if (b == 34) {
                this.inString = true;
                if (!this.beginObjectOrList) continue;
                this.writeNewLineWithIndent();
                this.beginObjectOrList = false;
                continue;
            }
            if (b == 44) {
                this.out.write(bytes, start, i - start + 1);
                start = i + 1;
                this.writeNewLineWithIndent();
                continue;
            }
            if (b == 58) {
                this.out.write(bytes, start, i - start + 1);
                start = i + 1;
                this.out.write(32);
                continue;
            }
            if (b == 123 || b == 91) {
                if (this.beginObjectOrList) {
                    this.writeNewLineWithIndent();
                }
                this.beginObjectOrList = true;
                this.currentIndent += this.indentLength;
                this.out.write(bytes, start, i - start + 1);
                start = i + 1;
                continue;
            }
            if (b == 125 || b == 93) {
                this.currentIndent -= this.indentLength;
                this.out.write(bytes, start, i - start);
                if (this.beginObjectOrList) {
                    this.beginObjectOrList = false;
                } else {
                    this.writeNewLineWithIndent();
                }
                this.out.write(b);
                start = i + 1;
                continue;
            }
            if (WHITESPACE[b]) {
                this.out.write(bytes, start, i - start);
                start = i + 1;
                continue;
            }
            if (!this.beginObjectOrList) continue;
            this.writeNewLineWithIndent();
            this.beginObjectOrList = false;
        }
        int remaining = off + len - start;
        if (remaining > 0) {
            this.out.write(bytes, start, remaining);
        }
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.inString) {
            if (b == 34 && !this.inEscape) {
                this.inString = false;
            } else {
                this.inEscape = !this.inEscape && b == 92;
            }
            this.out.write(b);
        } else if (b == 34) {
            this.inString = true;
            if (this.beginObjectOrList) {
                this.writeNewLineWithIndent();
                this.beginObjectOrList = false;
            }
            this.out.write(b);
        } else if (b == 44) {
            this.out.write(44);
            this.writeNewLineWithIndent();
        } else if (b == 58) {
            this.out.write(58);
            this.out.write(32);
        } else if (b == 123 || b == 91) {
            if (this.beginObjectOrList) {
                this.writeNewLineWithIndent();
            }
            this.beginObjectOrList = true;
            this.currentIndent += this.indentLength;
            this.out.write(b);
        } else if (b == 125 || b == 93) {
            this.currentIndent -= this.indentLength;
            if (this.beginObjectOrList) {
                this.beginObjectOrList = false;
            } else {
                this.writeNewLineWithIndent();
            }
            this.out.write(b);
        } else if (!WHITESPACE[b]) {
            if (this.beginObjectOrList) {
                this.writeNewLineWithIndent();
                this.beginObjectOrList = false;
            }
            this.out.write(b);
        }
    }

    private void writeNewLineWithIndent() throws IOException {
        int size = this.currentIndent + 1;
        if (size < 257) {
            this.out.write(this.indentType.cache, 0, size);
        } else {
            byte[] cache = this.indentType.cache;
            this.out.write(cache);
            int remaining = size - 257;
            while (true) {
                if (remaining < 257) {
                    this.out.write(cache, 1, remaining);
                    break;
                }
                this.out.write(cache, 1, 256);
                remaining -= 256;
            }
        }
    }

    static {
        PrettifyOutputStream.WHITESPACE[9] = true;
        PrettifyOutputStream.WHITESPACE[10] = true;
        PrettifyOutputStream.WHITESPACE[13] = true;
        PrettifyOutputStream.WHITESPACE[32] = true;
    }

    public static enum IndentType {
        SPACES(32),
        TABS(9);

        private final byte[] cache = new byte[257];

        private IndentType(byte b) {
            this.cache[0] = 10;
            Arrays.fill(this.cache, 1, this.cache.length, b);
        }
    }
}

