/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.runtime.ExplicitDescription;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\u0007\u000e\u0005YA\u0001\u0002\u0005\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001d\t\u0007A1A\u0005\n\tDa!\u001b\u0001!\u0002\u0013\u0019\u0007\"\u00026\u0001\t\u0003Z\u0007\"\u0002<\u0001\t\u00139\b\"B?\u0001\t\u0013q\bbBA\u0005\u0001\u0011%\u00111\u0002\u0002\u0010'\u000e\fG.Y'ba\u0016s7m\u001c3fe*\u0011abD\u0001\beVtG/[7f\u0015\t\u0001\u0012#\u0001\u0003kg>t'B\u0001\n\u0014\u0003-!7\u000f\u001c9mCR4wN]7\u000b\u0003Q\t1aY8n\u0007\u0001)2a\u0006\u001a>'\u0011\u0001\u0001\u0004I \u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t1qJ\u00196fGR\u00042!I\u0013)\u001d\t\u00113%D\u0001\u0010\u0013\t!s\"\u0001\u0006Kg>twK]5uKJL!AJ\u0014\u0003\u0017]\u0013\u0018\u000e^3PE*,7\r\u001e\u0006\u0003I=\u0001B!\u000b\u00181y5\t!F\u0003\u0002,Y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00035\nQa]2bY\u0006L!a\f\u0016\u0003\u00075\u000b\u0007\u000f\u0005\u00022e1\u0001A!B\u001a\u0001\u0005\u0004!$!A&\u0012\u0005UJ\u0004C\u0001\u001c8\u001b\u0005a\u0013B\u0001\u001d-\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u000e\u001e\n\u0005mb#aA!osB\u0011\u0011'\u0010\u0003\u0006}\u0001\u0011\r\u0001\u000e\u0002\u0002-B\u0011\u0001)Q\u0007\u0002\u001b%\u0011!)\u0004\u0002\u0014\u000bb\u0004H.[2ji\u0012+7o\u0019:jaRLwN\u001c\u0019\u0003\t\"\u00032AI#H\u0013\t1uBA\u0004Eg2T5o\u001c8\u0011\u0005EBE!C%\u0002\u0003\u0003\u0005\tQ!\u00015\u0005\ryF%M\u0001\u001bG\",7m\u001b$pe\u000e{gN^3sg&|g\u000eV8TiJLgn\u001a\t\u0003m1K!!\u0014\u0017\u0003\u000f\t{w\u000e\\3b]\u0006Q1.Z=F]\u000e|G-\u001a:\u0011\u0007Y\u0002&+\u0003\u0002RY\t1q\n\u001d;j_:\u00042!I\u00131\u000311\u0018\r\\;f\u000b:\u001cw\u000eZ3s!\r1\u0004+\u0016\t\u0004C\u0015b\u0014A\u0002\u001fj]&$h\bF\u0003Y3z{\u0006\r\u0005\u0003A\u0001Ab\u0004\"\u0002\t\u0006\u0001\u0004Q\u0006GA.^!\r\u0011S\t\u0018\t\u0003cu#\u0011\"S-\u0002\u0002\u0003\u0005)\u0011\u0001\u001b\t\u000b)+\u0001\u0019A&\t\u000b9+\u0001\u0019A(\t\u000bM+\u0001\u0019\u0001+\u0002\u000b\u0015k\u0005\u000bV-\u0016\u0003\r\u00042A\u000e3g\u0013\t)GFA\u0003BeJ\f\u0017\u0010\u0005\u00027O&\u0011\u0001\u000e\f\u0002\u0005\u0005f$X-\u0001\u0004F\u001bB#\u0016\fI\u0001\u0006oJLG/\u001a\u000b\u0004Y>$\bC\u0001\u001cn\u0013\tqGF\u0001\u0003V]&$\b\"\u00029\t\u0001\u0004\t\u0018AB<sSR,'\u000f\u0005\u0002#e&\u00111o\u0004\u0002\u000b\u0015N|gn\u0016:ji\u0016\u0014\b\"B;\t\u0001\u0004A\u0013!\u0002<bYV,\u0017aC<sSR,Gi\\;cY\u0016$2\u0001\u001c=}\u0011\u0015)\u0018\u00021\u0001z!\t1$0\u0003\u0002|Y\t1Ai\\;cY\u0016DQ\u0001]\u0005A\u0002E\f!b\u001e:ji\u00164En\\1u)\u0011aw0a\u0002\t\rUT\u0001\u0019AA\u0001!\r1\u00141A\u0005\u0004\u0003\u000ba#!\u0002$m_\u0006$\b\"\u00029\u000b\u0001\u0004\t\u0018aC<sSR,\u0017+^8uK\u0012$r\u0001\\A\u0007\u0003\u001f\t\u0019\u0002C\u0003q\u0017\u0001\u0007\u0011\u000f\u0003\u0004\u0002\u0012-\u0001\rAU\u0001\nW\u0016LxK]5uKJDa!!\u0006\f\u0001\u0004\u0001\u0014aA6fs\u0002")
public final class ScalaMapEncoder<K, V>
implements JsonWriter.WriteObject<Map<K, V>>,
ExplicitDescription {
    private final DslJson<?> json;
    private final boolean checkForConversionToString;
    private final Option<JsonWriter.WriteObject<K>> keyEncoder;
    private final Option<JsonWriter.WriteObject<V>> valueEncoder;
    private final byte[] EMPTY;

    private byte[] EMPTY() {
        return this.EMPTY;
    }

    public void write(JsonWriter writer, Map<K, V> value) {
        block22: {
            block24: {
                block23: {
                    block21: {
                        if (value != null) break block21;
                        writer.writeNull();
                        break block22;
                    }
                    if (!value.isEmpty()) break block23;
                    writer.writeAscii(this.EMPTY());
                    break block22;
                }
                if (!this.keyEncoder.isDefined() || !this.valueEncoder.isDefined()) break block24;
                JsonWriter.WriteObject ke = (JsonWriter.WriteObject)this.keyEncoder.get();
                JsonWriter.WriteObject ve = (JsonWriter.WriteObject)this.valueEncoder.get();
                writer.writeByte((byte)123);
                Iterator iter = value.iterator();
                Tuple2 tuple2 = (Tuple2)iter.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k1 = tuple2._1();
                Object v1 = tuple2._2();
                Tuple2 tuple22 = new Tuple2(k1, v1);
                Tuple2 tuple23 = tuple22;
                Object k12 = tuple23._1();
                Object v12 = tuple23._2();
                if (this.checkForConversionToString) {
                    this.writeQuoted(writer, ke, k12);
                } else {
                    ke.write(writer, k12);
                }
                writer.writeByte((byte)58);
                ve.write(writer, v12);
                while (iter.hasNext()) {
                    Tuple2 tuple24 = (Tuple2)iter.next();
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    Object k = tuple24._1();
                    Object v = tuple24._2();
                    Tuple2 tuple25 = new Tuple2(k, v);
                    Tuple2 tuple26 = tuple25;
                    Object k2 = tuple26._1();
                    Object v2 = tuple26._2();
                    writer.writeByte((byte)44);
                    if (this.checkForConversionToString) {
                        this.writeQuoted(writer, ke, k2);
                    } else {
                        ke.write(writer, k2);
                    }
                    writer.writeByte((byte)58);
                    ve.write(writer, v2);
                }
                writer.writeByte((byte)125);
                break block22;
            }
            boolean pastFirst = false;
            writer.writeByte((byte)123);
            None$ lastKeyClass = None$.MODULE$;
            None$ lastValueClass = None$.MODULE$;
            Some lastKeyEncoder = this.keyEncoder;
            None$ lastValueEncoder = None$.MODULE$;
            for (Tuple2 tuple2 : value) {
                Object v;
                block26: {
                    block25: {
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object k = tuple2._1();
                        Object v3 = tuple2._2();
                        Tuple2 tuple27 = new Tuple2(k, v3);
                        Tuple2 tuple28 = tuple27;
                        Object k3 = tuple28._1();
                        v = tuple28._2();
                        if (pastFirst) {
                            writer.writeByte((byte)44);
                        } else {
                            pastFirst = true;
                        }
                        Class<?> currentKeyClass = k3.getClass();
                        if (this.keyEncoder.isEmpty() && !lastKeyClass.contains(currentKeyClass)) {
                            lastKeyClass = new Some(currentKeyClass);
                            JsonWriter.WriteObject writeObject = this.json.tryFindWriter(currentKeyClass);
                            if (writeObject instanceof JsonWriter.WriteObject) {
                                JsonWriter.WriteObject writeObject2 = writeObject;
                                lastKeyEncoder = new Some((Object)writeObject2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                throw new ConfigurationException(new StringBuilder(26).append("Unable to find writer for ").append(lastKeyClass).toString());
                            }
                        }
                        this.writeQuoted(writer, (JsonWriter.WriteObject)lastKeyEncoder.get(), k3);
                        writer.writeByte((byte)58);
                        if (this.valueEncoder.isDefined()) {
                            ((JsonWriter.WriteObject)this.valueEncoder.get()).write(writer, v);
                            continue;
                        }
                        if (v == null) break block25;
                        Object object = v;
                        None$ none$ = None$.MODULE$;
                        if (object != null ? !object.equals(none$) : none$ != null) break block26;
                    }
                    writer.writeNull();
                    continue;
                }
                Class<?> currentValueClass = v.getClass();
                if (!lastValueClass.contains(currentValueClass)) {
                    lastValueClass = new Some(currentValueClass);
                    JsonWriter.WriteObject writeObject = this.json.tryFindWriter(currentValueClass);
                    if (writeObject instanceof JsonWriter.WriteObject) {
                        JsonWriter.WriteObject writeObject3 = writeObject;
                        lastValueEncoder = new Some((Object)writeObject3);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new ConfigurationException(new StringBuilder(26).append("Unable to find writer for ").append(lastValueClass).toString());
                    }
                }
                ((JsonWriter.WriteObject)lastValueEncoder.get()).write(writer, v);
            }
            writer.writeByte((byte)125);
        }
    }

    private void writeDouble(double value, JsonWriter writer) {
        if (value == Double.NaN) {
            writer.writeAscii("NaN");
        } else if (value == Double.POSITIVE_INFINITY) {
            writer.writeAscii("Infinity");
        } else if (value == Double.NEGATIVE_INFINITY) {
            writer.writeAscii("-Infinity");
        } else {
            writer.writeByte((byte)34);
            NumberConverter.serialize((double)value, (JsonWriter)writer);
            writer.writeByte((byte)34);
        }
    }

    private void writeFloat(float value, JsonWriter writer) {
        if (value == Float.NaN) {
            writer.writeAscii("NaN");
        } else if (value == Float.POSITIVE_INFINITY) {
            writer.writeAscii("Infinity");
        } else if (value == Float.NEGATIVE_INFINITY) {
            writer.writeAscii("-Infinity");
        } else {
            writer.writeByte((byte)34);
            NumberConverter.serialize((float)value, (JsonWriter)writer);
            writer.writeByte((byte)34);
        }
    }

    private void writeQuoted(JsonWriter writer, JsonWriter.WriteObject<K> keyWriter, K key) {
        K k = key;
        if (k instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(k);
            this.writeDouble(d, writer);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (k instanceof Double) {
            Double d = (Double)k;
            this.writeDouble(Predef$.MODULE$.Double2double(d), writer);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (k instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(k);
            this.writeFloat(f, writer);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (k instanceof Float) {
            Float f = (Float)k;
            this.writeFloat(Predef$.MODULE$.Float2float(f), writer);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (k instanceof Number) {
            writer.writeByte((byte)34);
            keyWriter.write(writer, key);
            writer.writeByte((byte)34);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            keyWriter.write(writer, key);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ScalaMapEncoder(DslJson<?> json, boolean checkForConversionToString, Option<JsonWriter.WriteObject<K>> keyEncoder, Option<JsonWriter.WriteObject<V>> valueEncoder) {
        this.json = json;
        this.checkForConversionToString = checkForConversionToString;
        this.keyEncoder = keyEncoder;
        this.valueEncoder = valueEncoder;
        Predef$.MODULE$.require(json != null, (Function0 & Serializable & scala.Serializable)() -> "json can't be null");
        Predef$.MODULE$.require(keyEncoder != null, (Function0 & Serializable & scala.Serializable)() -> "keyEncoder can't be null");
        Predef$.MODULE$.require(valueEncoder != null, (Function0 & Serializable & scala.Serializable)() -> "valueEncoder can't be null");
        this.EMPTY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{123, 125}), ClassTag$.MODULE$.Byte());
    }
}

