/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.hibernate;

import com.elepy.Configuration;
import com.elepy.ElepyPostConfiguration;
import com.elepy.ElepyPreConfiguration;
import com.elepy.hibernate.HibernateCrudFactory;
import java.util.Properties;
import org.hibernate.SessionFactory;

public class HibernateConfiguration
implements Configuration {
    private final org.hibernate.cfg.Configuration hibernateConfiguration;

    public HibernateConfiguration(org.hibernate.cfg.Configuration hibernateConfiguration) {
        this.hibernateConfiguration = hibernateConfiguration;
    }

    public static HibernateConfiguration of(org.hibernate.cfg.Configuration c) {
        return new HibernateConfiguration(c);
    }

    public static HibernateConfiguration fromEnv(String hibernateCfgXml) {
        return HibernateConfiguration.of(new org.hibernate.cfg.Configuration().configure(hibernateCfgXml));
    }

    public static HibernateConfiguration fromEnv() {
        return HibernateConfiguration.of(new org.hibernate.cfg.Configuration().configure("hibernate.cfg.xml"));
    }

    public static HibernateConfiguration inMemory() {
        return HibernateConfiguration.createInMemoryHibernateConfig("org.h2.Driver", "jdbc:h2:mem:testDB;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE", "org.hibernate.dialect.H2Dialect", "SA", "");
    }

    static HibernateConfiguration createInMemoryHibernateConfig(String driverClassName, String url, String dialect, String username, String password) {
        Properties properties = new Properties();
        properties.setProperty("hibernate.connection.driver_class", driverClassName);
        properties.setProperty("hibernate.connection.url", url);
        properties.setProperty("hibernate.connection.username", username);
        properties.setProperty("hibernate.connection.password", password);
        properties.setProperty("hibernate.show_sql", "false");
        properties.setProperty("hibernate.dialect", dialect);
        properties.setProperty("hibernate.hbm2ddl.auto", "create");
        return HibernateConfiguration.of(new org.hibernate.cfg.Configuration().setProperties(properties));
    }

    public void preConfig(ElepyPreConfiguration elepy) {
    }

    public void afterPreConfig(ElepyPreConfiguration elepy) {
        elepy.modelClasses().forEach(arg_0 -> ((org.hibernate.cfg.Configuration)this.hibernateConfiguration).addAnnotatedClass(arg_0));
        SessionFactory sessionFactory = this.hibernateConfiguration.buildSessionFactory();
        elepy.registerDependency(SessionFactory.class, (Object)sessionFactory);
        elepy.withDefaultCrudFactory(HibernateCrudFactory.class);
    }

    public void postConfig(ElepyPostConfiguration elepy) {
    }
}

