/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.hibernate;

import com.elepy.annotations.Searchable;
import com.elepy.annotations.Unique;
import com.elepy.dao.Crud;
import com.elepy.dao.Filter;
import com.elepy.dao.Page;
import com.elepy.dao.PageSettings;
import com.elepy.dao.Query;
import com.elepy.dao.SortOption;
import com.elepy.exceptions.ElepyConfigException;
import com.elepy.exceptions.ElepyException;
import com.elepy.hibernate.HibernatePredicateFactory;
import com.elepy.models.Model;
import com.elepy.utils.ReflectionUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateDao<T>
implements Crud<T> {
    private static final Logger logger = LoggerFactory.getLogger(HibernateDao.class);
    private final SessionFactory sessionFactory;
    private final Model<T> model;
    private final ObjectMapper objectMapper;

    public HibernateDao(SessionFactory sessionFactory, ObjectMapper objectMapper, Model<T> model) {
        this.sessionFactory = sessionFactory;
        this.model = model;
        this.objectMapper = objectMapper;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private Page<T> toPage(org.hibernate.query.Query<T> query, int pageSize, long pageNumber, long amountOfResultsWithThatQuery) {
        org.hibernate.query.Query q = query.setMaxResults(pageSize).setFirstResult(((int)pageNumber - 1) * pageSize);
        List values = q.list();
        if (amountOfResultsWithThatQuery == -1L) {
            amountOfResultsWithThatQuery = values.size();
        }
        this.loadLazyCollections(values);
        long remainder = amountOfResultsWithThatQuery % (long)pageSize;
        long amountOfPages = amountOfResultsWithThatQuery / (long)pageSize;
        if (remainder > 0L) {
            ++amountOfPages;
        }
        return new Page(pageNumber, amountOfPages, values);
    }

    public Page<T> search(Query query, PageSettings settings) {
        try (Session session = this.sessionFactory.openSession();){
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(this.getType());
            Root root = criteriaQuery.from(this.getType());
            Predicate predicate = this.generateSearchQuery(cb, root, query);
            List<Order> orders = this.generateOrderBy(cb, root, settings);
            org.hibernate.query.Query qry = session.createQuery(criteriaQuery.select((Selection)root).where((Expression)predicate).orderBy(orders));
            Page<T> page = this.toPage(qry, settings.getPageSize(), settings.getPageNumber(), this.count(query));
            return page;
        }
    }

    private List<Order> generateOrderBy(CriteriaBuilder cb, Root<T> root, PageSettings settings) {
        return settings.getPropertySortList().stream().map(propertySort -> {
            if (propertySort.getSortOption().equals((Object)SortOption.ASCENDING)) {
                return cb.asc((Expression)root.get(propertySort.getProperty()));
            }
            return cb.desc((Expression)root.get(propertySort.getProperty()));
        }).collect(Collectors.toList());
    }

    private Predicate generateSearchQuery(CriteriaBuilder cb, Root<T> root, Query query) {
        ArrayList<Predicate> filterList = new ArrayList<Predicate>();
        for (Filter filter : query.getFilters()) {
            filterList.add(HibernatePredicateFactory.fromFilter(root, cb, filter));
        }
        return cb.and((Expression)cb.and(filterList.toArray(new Predicate[0])), (Expression)cb.or(this.getSearchPredicates(root, cb, query.getSearchQuery()).toArray(new Predicate[0])));
    }

    private List<Predicate> getSearchPredicates(Root<T> root, CriteriaBuilder cb, String term) {
        if (term == null || term.trim().isEmpty()) {
            return Collections.singletonList(cb.and(new Predicate[0]));
        }
        return this.getSearchableFields().stream().map(field -> cb.like(cb.lower((Expression)root.get(this.getJPAFieldName((Field)field))), cb.literal((Object)("%" + term.toLowerCase() + "%")))).collect(Collectors.toList());
    }

    public Optional<T> getById(Serializable id) {
        if (id == null) {
            return Optional.empty();
        }
        try (Session session = this.sessionFactory.openSession();){
            Object t = session.get(this.getType(), id);
            this.loadLazyCollections(t);
            Optional<Object> optional = Optional.ofNullable(t);
            return optional;
        }
    }

    public List<T> searchInField(Field field, String qry) {
        try (Session session = this.sessionFactory.openSession();){
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(this.getType());
            Root root = criteriaQuery.from(this.getType());
            if (field.getType().equals(String.class)) {
                criteriaQuery.select((Selection)root).where((Expression)cb.like((Expression)root.get(this.getJPAFieldName(field)), qry));
            } else {
                criteriaQuery.select((Selection)root).where((Expression)cb.equal((Expression)root.get(this.getJPAFieldName(field)), (Object)Long.parseLong(qry)));
            }
            org.hibernate.query.Query query = session.createQuery(criteriaQuery);
            List resultList = query.list();
            this.loadLazyCollections(resultList);
            List list = resultList;
            return list;
        }
    }

    public void update(T item) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction transaction = session.beginTransaction();
            session.update(item);
            transaction.commit();
        }
    }

    private void create(Session session, T item) {
        session.save(item);
    }

    public void create(T item) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction transaction = session.beginTransaction();
            this.create(session, item);
            transaction.commit();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ElepyException(e.getMessage());
        }
    }

    public List<T> getAll() {
        try (Session session = this.sessionFactory.openSession();){
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(this.getType());
            Root root = criteriaQuery.from(this.getType());
            List list = session.createQuery(criteriaQuery.select((Selection)root)).getResultList();
            return list;
        }
    }

    public void create(Iterable<T> items) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction transaction = session.beginTransaction();
            for (T item : items) {
                this.create(session, item);
            }
            transaction.commit();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ElepyException(e.getMessage());
        }
    }

    public Model<T> getModel() {
        return this.model;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public long count(Query query) {
        try (Session session = this.sessionFactory.openSession();){
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(Long.class);
            Root root = criteriaQuery.from(this.getType());
            criteriaQuery.select((Selection)cb.count((Expression)root));
            Predicate predicate = this.generateSearchQuery(cb, root, query);
            criteriaQuery.where((Expression)predicate);
            org.hibernate.query.Query query1 = session.createQuery(criteriaQuery);
            query1.getResultList();
            long l = (Long)query1.getSingleResult();
            return l;
        }
    }

    public void deleteById(Serializable id) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction transaction = session.beginTransaction();
            Object item = session.get(this.getType(), id);
            if (item != null) {
                session.delete(item);
            }
            transaction.commit();
        }
    }

    public long count() {
        try (Session session = this.sessionFactory.openSession();){
            org.hibernate.query.Query query = session.createQuery("select count(*) from " + this.getType().getName(), Long.class);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    private String getJPAFieldName(Field field) {
        Column annotation = field.getAnnotation(Column.class);
        if (annotation != null && !annotation.name().isEmpty()) {
            return annotation.name();
        }
        return field.getName();
    }

    private void loadLazyCollections(Object object) {
        try {
            this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ElepyException("Error loading object's collections.");
        }
    }

    private List<Field> getSearchableFields() {
        List fields = ReflectionUtils.searchForFieldsWithAnnotation((Class)this.getType(), (Class[])new Class[]{Searchable.class, Unique.class});
        Field idProperty = (Field)ReflectionUtils.getIdField((Class)this.getType()).orElseThrow(() -> new ElepyConfigException("No id idProperty"));
        fields.add(idProperty);
        fields.removeIf(field -> !field.getType().equals(String.class));
        return fields;
    }
}

