/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.hibernate;

import com.elepy.dao.Filter;
import com.elepy.dao.FilterableField;
import com.elepy.exceptions.ElepyException;
import com.elepy.models.FieldType;
import com.elepy.utils.MapperUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public class HibernatePredicateFactory {
    public static Predicate fromFilter(Root root, CriteriaBuilder cb, Filter filter) {
        Serializable value = HibernatePredicateFactory.value(filter.getFilterableField(), filter.getFilterValue());
        FieldType fieldType = filter.getFilterableField().getFieldType();
        String fieldName = filter.getFilterableField().getField().getName();
        switch (filter.getFilterType()) {
            case EQUALS: {
                return cb.equal((Expression)root.get(fieldName), (Object)value);
            }
            case NOT_EQUALS: {
                return cb.notEqual((Expression)root.get(fieldName), (Object)value);
            }
            case CONTAINS: {
                if (fieldType.equals((Object)FieldType.ARRAY)) {
                    throw new ElepyException("The 'contains' filter can't be applied to arrays (yet)");
                }
                return cb.like((Expression)root.get(fieldName), "%" + value + "%");
            }
            case GREATER_THAN: {
                if (fieldType.equals((Object)FieldType.DATE)) {
                    return cb.greaterThan(root.get(fieldName).as(Date.class), (Comparable)((Date)value));
                }
                return cb.gt((Expression)root.get(fieldName), (Number)value);
            }
            case LESSER_THAN: {
                if (fieldType.equals((Object)FieldType.DATE)) {
                    return cb.lessThan(root.get(fieldName).as(Date.class), (Comparable)((Date)value));
                }
                return cb.lt((Expression)root.get(fieldName), (Number)value);
            }
            case GREATER_THAN_OR_EQUALS: {
                if (fieldType.equals((Object)FieldType.DATE)) {
                    return cb.greaterThanOrEqualTo(root.get(fieldName).as(Date.class), (Comparable)((Date)value));
                }
                return cb.ge((Expression)root.get(fieldName), (Number)value);
            }
            case LESSER_THAN_OR_EQUALS: {
                if (fieldType.equals((Object)FieldType.DATE)) {
                    return cb.lessThanOrEqualTo(root.get(fieldName).as(Date.class), (Comparable)((Date)value));
                }
                return cb.le((Expression)root.get(fieldName), (Number)value);
            }
            case IS_NULL: {
                return cb.isNull((Expression)root.get(fieldName));
            }
            case NOT_NULL: {
                return cb.isNotNull((Expression)root.get(fieldName));
            }
            case STARTS_WITH: {
                return cb.like((Expression)root.get(fieldName), value + "%");
            }
        }
        throw new ElepyException("Hibernate does not support the filter: " + filter.getFilterType().getName());
    }

    private static Serializable value(FilterableField field, String value) {
        return MapperUtils.toValueFromString((Field)field.getField(), (FieldType)field.getFieldType(), (String)value);
    }
}

