/*
 * $Id: SystemProperties.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

/**
 * delegates all request to <code>getProperty</code> to the system properties.
 * 
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class SystemProperties extends Properties {
    
    /**
     * The only instance.
     */
    public static final SystemProperties INSTANCE = new SystemProperties();
    
    /**
     * Singleton constructor.
     */
    private SystemProperties() {
        // Singleton constructor.
    }
    
    /*
     * @see com.eva.properties.Properties#getProperty(
     *      com.eva.properties.Context, java.lang.String)
     */
    Object getProperty(Context inContext, String inKey) {
        return System.getProperty(inKey);
    }

    /*
     * @see com.eva.properties.Properties#putProperty(
     *      com.eva.properties.Context, java.lang.String, java.lang.Object)
     */
    Object putProperty(Context inContext, String inKey, Object inValue) {
        return System.setProperty(inKey, String.valueOf(inValue));
    }

    /*
     * @see com.eva.properties.Properties#toString(java.lang.StringBuffer,
     *      java.lang.String)
     */
    void write(Writer inoutWriter) {
        inoutWriter.append("system");
        inoutWriter.appendNewline();
    }

    /*
     * @see com.eva.properties.Properties#copy(com.eva.properties.Properties)
     */
    Properties copy(Properties inParent) {
        return INSTANCE;
    }

}
