/*
 * $Id: Log.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.util.logging.Logger;

import com.eva.log.EvaLog;

/**
 * provides the logger for all classes in this package.
 * 
 * @author Max Antoni
 * @version $Revision: 109 $
 */
class Log {
    private static final Logger INSTANCE = EvaLog.create(Log.class);
    
    /**
     * Never instanciated.
     */
    private Log() {
        // Never instanciated.
    }
    
    /**
     * provides the logger instance for this package. If the logger is not yet
     * available, because it is currently created, the default logger is
     * returned.
     * 
     * @return the logger.
     */
    static Logger instance() {
        if(INSTANCE == null) {
            return EvaLog.getDefault();
        }
        return INSTANCE;
    }
    
}
