/*
 * $Id: NoProperties.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

/**
 * <code>null</code> object for properties.
 * 
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class NoProperties extends Properties {
    /**
     * the only instance.
     */
    public static final NoProperties INSTANCE = new NoProperties();
    
    /**
     * singleton constructor.
     */
    private NoProperties() {
        super();
    }

    /*
     * @see com.eva.properties.Properties#getProperty(
     *      com.eva.properties.Context, java.lang.String)
     */
    Object getProperty(Context inContext, String inKey) {
        return null;
    }

    /*
     * @see com.eva.properties.Properties#putProperty(
     *      com.eva.properties.Context, java.lang.String, java.lang.Object)
     */
    Object putProperty(Context inContext, String inKey, Object inValue)
            throws PropertiesException {
        throw new PropertiesException(inKey + " is not available.");
    }

    /*
     * @see com.eva.properties.Properties#toString(java.lang.StringBuffer,
     *      java.lang.String)
     */
    void write(Writer inoutWriter) {
        inoutWriter.appendIndentation();
        inoutWriter.append("/* No properties */\n");
    }

    /*
     * @see com.eva.properties.Properties#copy(com.eva.properties.Properties)
     */
    Properties copy(Properties inParent) {
        return INSTANCE;
    }

}
