/*
 * $Id: Null.java 109 2007-03-24 14:55:03Z max $
 *
 * Copyright (c) 2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

/**
 * <code>null</code> object for values.
 * 
 * @author max
 * @version $Revision: 109 $
 */
public class Null implements Replaceable {
    public static final Null INSTANCE = new Null();
    
    /**
     * Singleton constructor.
     */
    private Null() {
        // Singleton constructor.
    }
    
    /*
     * @see com.eva.properties.Replaceable#copy(com.eva.properties.Properties)
     */
    public Replaceable copy(Properties inParent) {
        return INSTANCE;
    }

    /*
     * @see com.eva.properties.Replaceable#replace(com.eva.properties.Context)
     */
    public Object replace(Context inContext) throws PropertiesException {
        return null;
    }

    /*
     * @see com.eva.properties.Replaceable#write(com.eva.properties.Writer)
     */
    public void write(Writer inoutWriter) {
        inoutWriter.append("null");
        inoutWriter.appendNewline();
    }

}
